/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.hashing.HashFunction;
import org.neo4j.values.storable.StringValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;

final class StringWrappingStringValue
extends StringValue {
    private final String value;

    StringWrappingStringValue(String value2) {
        assert (value2 != null);
        this.value = value2;
    }

    @Override
    String value() {
        return this.value;
    }

    @Override
    public int length() {
        return this.value.codePointCount(0, this.value.length());
    }

    @Override
    public int computeHash() {
        int codePoint;
        if (this.value.isEmpty()) {
            return 0;
        }
        int h = 1;
        int length2 = this.value.length();
        for (int offset = 0; offset < length2; offset += Character.charCount(codePoint)) {
            codePoint = this.value.codePointAt(offset);
            h = 31 * h + codePoint;
        }
        return h;
    }

    @Override
    public long updateHash(HashFunction hashFunction, long hash) {
        return StringWrappingStringValue.updateHash(hashFunction, hash, this.value);
    }

    public static long updateHash(HashFunction hashFunction, long hash, String value2) {
        int length2 = value2.length();
        int codePointCount = 0;
        int offset = 0;
        while (offset < length2) {
            int codePointA = value2.codePointAt(offset);
            int codePointB = 0;
            ++codePointCount;
            if ((offset += Character.charCount(codePointA)) < length2) {
                codePointB = value2.codePointAt(offset);
                offset += Character.charCount(codePointB);
                ++codePointCount;
            }
            hash = hashFunction.update(hash, ((long)codePointA << 32) + (long)codePointB);
        }
        return hashFunction.update(hash, codePointCount);
    }

    @Override
    public TextValue substring(int start, int length2) {
        int s2 = Math.min(start, this.length());
        int e = Math.min(s2 + length2, this.length());
        int codePointStart = this.value.offsetByCodePoints(0, s2);
        int codePointEnd = this.value.offsetByCodePoints(0, e);
        return Values.stringValue(this.value.substring(codePointStart, codePointEnd));
    }

    @Override
    public TextValue trim() {
        int start = this.ltrimIndex(this.value);
        int end = this.rtrimIndex(this.value);
        return Values.stringValue(this.value.substring(start, Math.max(end, start)));
    }

    @Override
    public TextValue ltrim() {
        int start = this.ltrimIndex(this.value);
        return Values.stringValue(this.value.substring(start, this.value.length()));
    }

    @Override
    public TextValue rtrim() {
        int end = this.rtrimIndex(this.value);
        return Values.stringValue(this.value.substring(0, end));
    }

    @Override
    public TextValue reverse() {
        StringBuilder stringBuilder = new StringBuilder(this.value());
        return Values.stringValue(stringBuilder.reverse().toString());
    }

    @Override
    public TextValue plus(TextValue other2) {
        return new StringWrappingStringValue(this.value + other2.stringValue());
    }

    @Override
    public boolean startsWith(TextValue other2) {
        return this.value.startsWith(other2.stringValue());
    }

    @Override
    public boolean endsWith(TextValue other2) {
        return this.value.endsWith(other2.stringValue());
    }

    @Override
    public boolean contains(TextValue other2) {
        return this.value.contains(other2.stringValue());
    }

    @Override
    Matcher matcher(Pattern pattern) {
        return pattern.matcher(this.value);
    }

    private int ltrimIndex(String value2) {
        int start;
        int codePoint;
        int length2 = value2.length();
        for (start = 0; start < length2 && Character.isWhitespace(codePoint = value2.codePointAt(start)); start += Character.charCount(codePoint)) {
        }
        return start;
    }

    private int rtrimIndex(String value2) {
        int codePoint;
        int end;
        for (end = value2.length(); end > 0 && Character.isWhitespace(codePoint = value2.codePointBefore(end)); --end) {
        }
        return end;
    }
}

