/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.lang.reflect.Array;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.neo4j.graphdb.spatial.CRS;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.BooleanArray;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.ByteArray;
import org.neo4j.values.storable.ByteValue;
import org.neo4j.values.storable.CharArray;
import org.neo4j.values.storable.CharValue;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DateArray;
import org.neo4j.values.storable.DateTimeArray;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DoubleArray;
import org.neo4j.values.storable.DoubleValue;
import org.neo4j.values.storable.DurationArray;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.FloatArray;
import org.neo4j.values.storable.FloatValue;
import org.neo4j.values.storable.FloatingPointValue;
import org.neo4j.values.storable.IntArray;
import org.neo4j.values.storable.IntValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.LocalDateTimeArray;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeArray;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.LongArray;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.NoValue;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.PointArray;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.ShortArray;
import org.neo4j.values.storable.ShortValue;
import org.neo4j.values.storable.StringArray;
import org.neo4j.values.storable.StringValue;
import org.neo4j.values.storable.StringWrappingStringValue;
import org.neo4j.values.storable.TemporalArray;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TimeArray;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.UTF8StringValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueComparator;
import org.neo4j.values.storable.ValueGroup;

public final class Values {
    public static final Value MIN_NUMBER = Values.doubleValue(Double.NEGATIVE_INFINITY);
    public static final Value MAX_NUMBER = Values.doubleValue(Double.NaN);
    public static final Value ZERO_FLOAT = Values.doubleValue(0.0);
    public static final IntegralValue ZERO_INT = Values.longValue(0L);
    public static final Value MIN_STRING = StringValue.EMPTY;
    public static final Value MAX_STRING = Values.booleanValue(false);
    public static final BooleanValue TRUE = Values.booleanValue(true);
    public static final BooleanValue FALSE = Values.booleanValue(false);
    public static final TextValue EMPTY_STRING = StringValue.EMPTY;
    public static final DoubleValue E = Values.doubleValue(Math.E);
    public static final DoubleValue PI = Values.doubleValue(Math.PI);
    public static final ArrayValue EMPTY_SHORT_ARRAY = Values.shortArray(new short[0]);
    public static final ArrayValue EMPTY_BOOLEAN_ARRAY = Values.booleanArray(new boolean[0]);
    public static final ArrayValue EMPTY_BYTE_ARRAY = Values.byteArray(new byte[0]);
    public static final ArrayValue EMPTY_CHAR_ARRAY = Values.charArray(new char[0]);
    public static final ArrayValue EMPTY_INT_ARRAY = Values.intArray(new int[0]);
    public static final ArrayValue EMPTY_LONG_ARRAY = Values.longArray(new long[0]);
    public static final ArrayValue EMPTY_FLOAT_ARRAY = Values.floatArray(new float[0]);
    public static final ArrayValue EMPTY_DOUBLE_ARRAY = Values.doubleArray(new double[0]);
    public static final TextArray EMPTY_TEXT_ARRAY = Values.stringArray(new String[0]);
    public static final ValueComparator COMPARATOR = new ValueComparator(Enum::compareTo);
    public static final Value NO_VALUE = NoValue.NO_VALUE;

    private Values() {
    }

    public static boolean isNumberValue(Object value2) {
        return value2 instanceof NumberValue;
    }

    public static boolean isBooleanValue(Object value2) {
        return value2 instanceof BooleanValue;
    }

    public static boolean isTextValue(Object value2) {
        return value2 instanceof TextValue;
    }

    public static boolean isArrayValue(Value value2) {
        return value2 instanceof ArrayValue;
    }

    public static boolean isGeometryValue(Value value2) {
        return value2 instanceof PointValue;
    }

    public static boolean isGeometryArray(Value value2) {
        return value2 instanceof PointArray;
    }

    public static boolean isTemporalValue(Value value2) {
        return value2 instanceof TemporalValue || value2 instanceof DurationValue;
    }

    public static boolean isTemporalArray(Value value2) {
        return value2 instanceof TemporalArray || value2 instanceof DurationArray;
    }

    public static double coerceToDouble(Value value2) {
        if (value2 instanceof IntegralValue) {
            return ((IntegralValue)value2).longValue();
        }
        if (value2 instanceof FloatingPointValue) {
            return ((FloatingPointValue)value2).doubleValue();
        }
        throw new UnsupportedOperationException(String.format("Cannot coerce %s to double", value2));
    }

    public static TextValue utf8Value(byte[] bytes2) {
        if (bytes2.length == 0) {
            return EMPTY_STRING;
        }
        return Values.utf8Value(bytes2, 0, bytes2.length);
    }

    public static TextValue utf8Value(byte[] bytes2, int offset, int length2) {
        if (length2 == 0) {
            return EMPTY_STRING;
        }
        return new UTF8StringValue(bytes2, offset, length2);
    }

    public static TextValue stringValue(String value2) {
        if (value2.isEmpty()) {
            return EMPTY_STRING;
        }
        return new StringWrappingStringValue(value2);
    }

    public static Value stringOrNoValue(String value2) {
        if (value2 == null) {
            return NO_VALUE;
        }
        return Values.stringValue(value2);
    }

    public static NumberValue numberValue(Number number) {
        if (number instanceof Long) {
            return Values.longValue(number.longValue());
        }
        if (number instanceof Integer) {
            return Values.intValue(number.intValue());
        }
        if (number instanceof Double) {
            return Values.doubleValue(number.doubleValue());
        }
        if (number instanceof Byte) {
            return Values.byteValue(number.byteValue());
        }
        if (number instanceof Float) {
            return Values.floatValue(number.floatValue());
        }
        if (number instanceof Short) {
            return Values.shortValue(number.shortValue());
        }
        throw new UnsupportedOperationException("Unsupported type of Number " + number.toString());
    }

    public static LongValue longValue(long value2) {
        return new LongValue(value2);
    }

    public static IntValue intValue(int value2) {
        return new IntValue(value2);
    }

    public static ShortValue shortValue(short value2) {
        return new ShortValue(value2);
    }

    public static ByteValue byteValue(byte value2) {
        return new ByteValue(value2);
    }

    public static BooleanValue booleanValue(boolean value2) {
        return value2 ? BooleanValue.TRUE : BooleanValue.FALSE;
    }

    public static CharValue charValue(char value2) {
        return new CharValue(value2);
    }

    public static DoubleValue doubleValue(double value2) {
        return new DoubleValue(value2);
    }

    public static FloatValue floatValue(float value2) {
        return new FloatValue(value2);
    }

    public static TextArray stringArray(String ... value2) {
        return new StringArray(value2);
    }

    public static ByteArray byteArray(byte[] value2) {
        return new ByteArray(value2);
    }

    public static LongArray longArray(long[] value2) {
        return new LongArray(value2);
    }

    public static IntArray intArray(int[] value2) {
        return new IntArray(value2);
    }

    public static DoubleArray doubleArray(double[] value2) {
        return new DoubleArray(value2);
    }

    public static FloatArray floatArray(float[] value2) {
        return new FloatArray(value2);
    }

    public static BooleanArray booleanArray(boolean[] value2) {
        return new BooleanArray(value2);
    }

    public static CharArray charArray(char[] value2) {
        return new CharArray(value2);
    }

    public static ShortArray shortArray(short[] value2) {
        return new ShortArray(value2);
    }

    public static PointValue unsafePointValue(CoordinateReferenceSystem crs, double ... coordinate) {
        return new PointValue(crs, coordinate);
    }

    public static PointValue pointValue(CoordinateReferenceSystem crs, double ... coordinate) {
        if (crs.getDimension() != coordinate.length) {
            throw new IllegalArgumentException(String.format("Cannot create point, CRS %s expects %d dimensions, but got coordinates %s", crs, crs.getDimension(), Arrays.toString(coordinate)));
        }
        return new PointValue(crs, coordinate);
    }

    public static PointValue point(Point point) {
        List<Double> coordinate = point.getCoordinate().getCoordinate();
        double[] coords = new double[coordinate.size()];
        for (int i = 0; i < coords.length; ++i) {
            coords[i] = coordinate.get(i);
        }
        return new PointValue(Values.crs(point.getCRS()), coords);
    }

    public static PointValue minPointValue(PointValue reference) {
        double[] coordinates = new double[reference.coordinate().length];
        Arrays.fill(coordinates, -1.7976931348623157E308);
        return Values.pointValue(reference.getCoordinateReferenceSystem(), coordinates);
    }

    public static PointValue maxPointValue(PointValue reference) {
        double[] coordinates = new double[reference.coordinate().length];
        Arrays.fill(coordinates, Double.MAX_VALUE);
        return Values.pointValue(reference.getCoordinateReferenceSystem(), coordinates);
    }

    public static PointArray pointArray(Point[] points) {
        PointValue[] values2 = new PointValue[points.length];
        for (int i = 0; i < points.length; ++i) {
            values2[i] = Values.point(points[i]);
        }
        return new PointArray(values2);
    }

    public static PointArray pointArray(Value[] maybePoints) {
        PointValue[] values2 = new PointValue[maybePoints.length];
        for (int i = 0; i < maybePoints.length; ++i) {
            Value maybePoint = maybePoints[i];
            if (!(maybePoint instanceof PointValue)) {
                throw new IllegalArgumentException(String.format("[%s:%s] is not a supported point value", maybePoint, maybePoint.getClass().getName()));
            }
            values2[i] = Values.point((PointValue)maybePoint);
        }
        return Values.pointArray(values2);
    }

    public static PointArray pointArray(PointValue[] points) {
        return new PointArray(points);
    }

    public static CoordinateReferenceSystem crs(CRS crs) {
        return CoordinateReferenceSystem.get(crs);
    }

    public static Value temporalValue(Temporal value2) {
        if (value2 instanceof ZonedDateTime) {
            return DateTimeValue.datetime((ZonedDateTime)value2);
        }
        if (value2 instanceof OffsetDateTime) {
            return DateTimeValue.datetime((OffsetDateTime)value2);
        }
        if (value2 instanceof LocalDateTime) {
            return LocalDateTimeValue.localDateTime((LocalDateTime)value2);
        }
        if (value2 instanceof OffsetTime) {
            return TimeValue.time((OffsetTime)value2);
        }
        if (value2 instanceof LocalDate) {
            return DateValue.date((LocalDate)value2);
        }
        if (value2 instanceof LocalTime) {
            return LocalTimeValue.localTime((LocalTime)value2);
        }
        if (value2 instanceof TemporalValue) {
            return (Value)((Object)value2);
        }
        if (value2 == null) {
            return NO_VALUE;
        }
        throw new UnsupportedOperationException("Unsupported type of Temporal " + value2.toString());
    }

    public static DurationValue durationValue(TemporalAmount value2) {
        if (value2 instanceof Duration) {
            return DurationValue.duration((Duration)value2);
        }
        if (value2 instanceof Period) {
            return DurationValue.duration((Period)value2);
        }
        if (value2 instanceof DurationValue) {
            return (DurationValue)value2;
        }
        DurationValue duration = DurationValue.duration(0L, 0L, 0L, 0L);
        for (TemporalUnit unit : value2.getUnits()) {
            duration = duration.plus(value2.get(unit), unit);
        }
        return duration;
    }

    public static DateTimeArray dateTimeArray(ZonedDateTime[] values2) {
        return new DateTimeArray(values2);
    }

    public static LocalDateTimeArray localDateTimeArray(LocalDateTime[] values2) {
        return new LocalDateTimeArray(values2);
    }

    public static LocalTimeArray localTimeArray(LocalTime[] values2) {
        return new LocalTimeArray(values2);
    }

    public static TimeArray timeArray(OffsetTime[] values2) {
        return new TimeArray(values2);
    }

    public static DateArray dateArray(LocalDate[] values2) {
        return new DateArray(values2);
    }

    public static DurationArray durationArray(DurationValue[] values2) {
        return new DurationArray(values2);
    }

    public static DurationArray durationArray(TemporalAmount[] values2) {
        DurationValue[] durations = new DurationValue[values2.length];
        for (int i = 0; i < values2.length; ++i) {
            durations[i] = Values.durationValue(values2[i]);
        }
        return new DurationArray(durations);
    }

    public static Value of(Object value2) {
        return Values.of(value2, true);
    }

    public static Value of(Object value2, boolean allowNull) {
        Value of = Values.unsafeOf(value2, allowNull);
        if (of != null) {
            return of;
        }
        Objects.requireNonNull(value2);
        throw new IllegalArgumentException(String.format("[%s:%s] is not a supported property value", value2, value2.getClass().getName()));
    }

    public static Value unsafeOf(Object value2, boolean allowNull) {
        if (value2 instanceof String) {
            return Values.stringValue((String)value2);
        }
        if (value2 instanceof Object[]) {
            return Values.arrayValue((Object[])value2);
        }
        if (value2 instanceof Boolean) {
            return Values.booleanValue((Boolean)value2);
        }
        if (value2 instanceof Number) {
            return Values.numberValue((Number)value2);
        }
        if (value2 instanceof Character) {
            return Values.charValue(((Character)value2).charValue());
        }
        if (value2 instanceof Temporal) {
            return Values.temporalValue((Temporal)value2);
        }
        if (value2 instanceof TemporalAmount) {
            return Values.durationValue((TemporalAmount)value2);
        }
        if (value2 instanceof byte[]) {
            return Values.byteArray((byte[])((byte[])value2).clone());
        }
        if (value2 instanceof long[]) {
            return Values.longArray((long[])((long[])value2).clone());
        }
        if (value2 instanceof int[]) {
            return Values.intArray((int[])((int[])value2).clone());
        }
        if (value2 instanceof double[]) {
            return Values.doubleArray((double[])((double[])value2).clone());
        }
        if (value2 instanceof float[]) {
            return Values.floatArray((float[])((float[])value2).clone());
        }
        if (value2 instanceof boolean[]) {
            return Values.booleanArray((boolean[])((boolean[])value2).clone());
        }
        if (value2 instanceof char[]) {
            return Values.charArray((char[])((char[])value2).clone());
        }
        if (value2 instanceof short[]) {
            return Values.shortArray((short[])((short[])value2).clone());
        }
        if (value2 == null) {
            if (allowNull) {
                return NoValue.NO_VALUE;
            }
            throw new IllegalArgumentException("[null] is not a supported property value");
        }
        if (value2 instanceof Point) {
            return Values.point((Point)value2);
        }
        if (value2 instanceof Value) {
            throw new UnsupportedOperationException("Converting a Value to a Value using Values.of() is not supported.");
        }
        return null;
    }

    public static Value[] values(Object ... objects) {
        return (Value[])Arrays.stream(objects).map(Values::of).toArray(Value[]::new);
    }

    @Deprecated
    public static Object asObject(Value value2) {
        return value2 == null ? null : value2.asObject();
    }

    public static Object[] asObjects(Value[] propertyValues) {
        Object[] legacy = new Object[propertyValues.length];
        for (int i = 0; i < propertyValues.length; ++i) {
            legacy[i] = propertyValues[i].asObjectCopy();
        }
        return legacy;
    }

    private static Value arrayValue(Object[] value2) {
        if (value2 instanceof String[]) {
            return Values.stringArray(Values.copy(value2, new String[value2.length]));
        }
        if (value2 instanceof Byte[]) {
            return Values.byteArray(Values.copy(value2, new byte[value2.length]));
        }
        if (value2 instanceof Long[]) {
            return Values.longArray(Values.copy(value2, new long[value2.length]));
        }
        if (value2 instanceof Integer[]) {
            return Values.intArray(Values.copy(value2, new int[value2.length]));
        }
        if (value2 instanceof Double[]) {
            return Values.doubleArray(Values.copy(value2, new double[value2.length]));
        }
        if (value2 instanceof Float[]) {
            return Values.floatArray(Values.copy(value2, new float[value2.length]));
        }
        if (value2 instanceof Boolean[]) {
            return Values.booleanArray(Values.copy(value2, new boolean[value2.length]));
        }
        if (value2 instanceof Character[]) {
            return Values.charArray(Values.copy(value2, new char[value2.length]));
        }
        if (value2 instanceof Short[]) {
            return Values.shortArray(Values.copy(value2, new short[value2.length]));
        }
        if (value2 instanceof PointValue[]) {
            return Values.pointArray(Values.copy(value2, new PointValue[value2.length]));
        }
        if (value2 instanceof Point[]) {
            return Values.pointArray((Point[])value2);
        }
        if (value2 instanceof ZonedDateTime[]) {
            return Values.dateTimeArray(Values.copy(value2, new ZonedDateTime[value2.length]));
        }
        if (value2 instanceof LocalDateTime[]) {
            return Values.localDateTimeArray(Values.copy(value2, new LocalDateTime[value2.length]));
        }
        if (value2 instanceof LocalTime[]) {
            return Values.localTimeArray(Values.copy(value2, new LocalTime[value2.length]));
        }
        if (value2 instanceof OffsetTime[]) {
            return Values.timeArray(Values.copy(value2, new OffsetTime[value2.length]));
        }
        if (value2 instanceof LocalDate[]) {
            return Values.dateArray(Values.copy(value2, new LocalDate[value2.length]));
        }
        if (value2 instanceof TemporalAmount[]) {
            return Values.durationArray((TemporalAmount[])value2);
        }
        return null;
    }

    private static <T> T copy(Object[] value2, T target) {
        for (int i = 0; i < value2.length; ++i) {
            if (value2[i] == null) {
                throw new IllegalArgumentException("Property array value elements may not be null.");
            }
            Array.set(target, i, value2[i]);
        }
        return target;
    }

    public static Value minValue(ValueGroup valueGroup, Value value2) {
        switch (valueGroup) {
            case TEXT: {
                return MIN_STRING;
            }
            case NUMBER: {
                return MIN_NUMBER;
            }
            case GEOMETRY: {
                return Values.minPointValue((PointValue)value2);
            }
            case DATE: {
                return DateValue.MIN_VALUE;
            }
            case LOCAL_DATE_TIME: {
                return LocalDateTimeValue.MIN_VALUE;
            }
            case ZONED_DATE_TIME: {
                return DateTimeValue.MIN_VALUE;
            }
            case LOCAL_TIME: {
                return LocalTimeValue.MIN_VALUE;
            }
            case ZONED_TIME: {
                return TimeValue.MIN_VALUE;
            }
        }
        throw new IllegalStateException(String.format("The minValue for valueGroup %s is not defined yet", new Object[]{valueGroup}));
    }

    public static Value maxValue(ValueGroup valueGroup, Value value2) {
        switch (valueGroup) {
            case TEXT: {
                return MAX_STRING;
            }
            case NUMBER: {
                return MAX_NUMBER;
            }
            case GEOMETRY: {
                return Values.maxPointValue((PointValue)value2);
            }
            case DATE: {
                return DateValue.MAX_VALUE;
            }
            case LOCAL_DATE_TIME: {
                return LocalDateTimeValue.MAX_VALUE;
            }
            case ZONED_DATE_TIME: {
                return DateTimeValue.MAX_VALUE;
            }
            case LOCAL_TIME: {
                return LocalTimeValue.MAX_VALUE;
            }
            case ZONED_TIME: {
                return TimeValue.MAX_VALUE;
            }
        }
        throw new IllegalStateException(String.format("The maxValue for valueGroup %s is not defined yet", new Object[]{valueGroup}));
    }
}

