/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.ComparativeRecordChecker;
import org.neo4j.consistency.checking.RecordCheck;
import org.neo4j.consistency.checking.index.IndexAccessors;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.internal.kernel.api.exceptions.schema.MalformedSchemaRuleException;
import org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaProcessor;
import org.neo4j.kernel.impl.store.SchemaRuleAccess;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.ConstraintRule;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.storageengine.api.schema.SchemaRule;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;

public class SchemaRecordCheck
implements RecordCheck<DynamicRecord, ConsistencyReport.SchemaConsistencyReport> {
    final SchemaRuleAccess ruleAccess;
    private final IndexAccessors indexAccessors;
    private final Map<Long, DynamicRecord> indexObligations;
    private final Map<Long, DynamicRecord> constraintObligations;
    private final Map<SchemaRule, DynamicRecord> verifiedRulesWithRecords;
    private final CheckStrategy strategy;
    private static final ComparativeRecordChecker<DynamicRecord, LabelTokenRecord, ConsistencyReport.SchemaConsistencyReport> VALID_LABEL = (record, labelTokenRecord, engine, records) -> {
        if (!labelTokenRecord.inUse()) {
            ((ConsistencyReport.SchemaConsistencyReport)engine.report()).labelNotInUse((LabelTokenRecord)labelTokenRecord);
        }
    };
    private static final ComparativeRecordChecker<DynamicRecord, RelationshipTypeTokenRecord, ConsistencyReport.SchemaConsistencyReport> VALID_RELATIONSHIP_TYPE = (record, relTypeTokenRecord, engine, records) -> {
        if (!relTypeTokenRecord.inUse()) {
            ((ConsistencyReport.SchemaConsistencyReport)engine.report()).relationshipTypeNotInUse((RelationshipTypeTokenRecord)relTypeTokenRecord);
        }
    };
    private static final ComparativeRecordChecker<DynamicRecord, PropertyKeyTokenRecord, ConsistencyReport.SchemaConsistencyReport> VALID_PROPERTY_KEY = (record, propertyKeyTokenRecord, engine, records) -> {
        if (!propertyKeyTokenRecord.inUse()) {
            ((ConsistencyReport.SchemaConsistencyReport)engine.report()).propertyKeyNotInUse((PropertyKeyTokenRecord)propertyKeyTokenRecord);
        }
    };

    public SchemaRecordCheck(SchemaRuleAccess ruleAccess, IndexAccessors indexAccessors) {
        this.ruleAccess = ruleAccess;
        this.indexAccessors = indexAccessors;
        this.indexObligations = new HashMap<Long, DynamicRecord>();
        this.constraintObligations = new HashMap<Long, DynamicRecord>();
        this.verifiedRulesWithRecords = new HashMap<SchemaRule, DynamicRecord>();
        this.strategy = new RulesCheckStrategy();
    }

    private SchemaRecordCheck(SchemaRuleAccess ruleAccess, IndexAccessors indexAccessors, Map<Long, DynamicRecord> indexObligations, Map<Long, DynamicRecord> constraintObligations, Map<SchemaRule, DynamicRecord> verifiedRulesWithRecords, CheckStrategy strategy) {
        this.ruleAccess = ruleAccess;
        this.indexAccessors = indexAccessors;
        this.indexObligations = indexObligations;
        this.constraintObligations = constraintObligations;
        this.verifiedRulesWithRecords = verifiedRulesWithRecords;
        this.strategy = strategy;
    }

    public SchemaRecordCheck forObligationChecking() {
        return new SchemaRecordCheck(this.ruleAccess, this.indexAccessors, this.indexObligations, this.constraintObligations, this.verifiedRulesWithRecords, new ObligationsCheckStrategy());
    }

    @Override
    public void check(DynamicRecord record, CheckerEngine<DynamicRecord, ConsistencyReport.SchemaConsistencyReport> engine, RecordAccess records) {
        if (record.inUse() && record.isStartRecord()) {
            SchemaRule rule;
            try {
                rule = this.ruleAccess.loadSingleSchemaRule(record.getId());
            }
            catch (MalformedSchemaRuleException e) {
                engine.report().malformedSchemaRule();
                return;
            }
            if (rule instanceof StoreIndexDescriptor) {
                this.strategy.checkIndexRule((StoreIndexDescriptor)rule, record, records, engine);
            } else if (rule instanceof ConstraintRule) {
                this.strategy.checkConstraintRule((ConstraintRule)rule, record, records, engine);
            } else {
                engine.report().unsupportedSchemaRuleKind(null);
            }
        }
    }

    private void checkSchema(SchemaRule rule, DynamicRecord record, RecordAccess records, CheckerEngine<DynamicRecord, ConsistencyReport.SchemaConsistencyReport> engine) {
        rule.schema().processWith((SchemaProcessor)new CheckSchema(engine, records));
        this.checkForDuplicates(rule, record, engine);
    }

    private <T extends AbstractBaseRecord> T cloneRecord(T record) {
        return (T)record.clone();
    }

    private void checkForDuplicates(SchemaRule rule, DynamicRecord record, CheckerEngine<DynamicRecord, ConsistencyReport.SchemaConsistencyReport> engine) {
        DynamicRecord previousContentRecord = this.verifiedRulesWithRecords.put(rule, this.cloneRecord(record));
        if (previousContentRecord != null) {
            engine.report().duplicateRuleContent(previousContentRecord);
        }
    }

    static class CheckSchema
    implements SchemaProcessor {
        private final CheckerEngine<DynamicRecord, ConsistencyReport.SchemaConsistencyReport> engine;
        private final RecordAccess records;

        CheckSchema(CheckerEngine<DynamicRecord, ConsistencyReport.SchemaConsistencyReport> engine, RecordAccess records) {
            this.engine = engine;
            this.records = records;
        }

        public void processSpecific(LabelSchemaDescriptor schema) {
            this.engine.comparativeCheck(this.records.label(schema.getLabelId()), VALID_LABEL);
            this.checkProperties(schema.getPropertyIds());
        }

        public void processSpecific(RelationTypeSchemaDescriptor schema) {
            this.engine.comparativeCheck(this.records.relationshipType(schema.getRelTypeId()), VALID_RELATIONSHIP_TYPE);
            this.checkProperties(schema.getPropertyIds());
        }

        public void processSpecific(SchemaDescriptor schema) {
            switch (schema.entityType()) {
                case NODE: {
                    for (int entityTokenId : schema.getEntityTokenIds()) {
                        this.engine.comparativeCheck(this.records.label(entityTokenId), VALID_LABEL);
                    }
                    break;
                }
                case RELATIONSHIP: {
                    for (int entityTokenId : schema.getEntityTokenIds()) {
                        this.engine.comparativeCheck(this.records.relationshipType(entityTokenId), VALID_RELATIONSHIP_TYPE);
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Schema with given entity type is not supported: " + schema.entityType());
                }
            }
            this.checkProperties(schema.getPropertyIds());
        }

        private void checkProperties(int[] propertyIds) {
            for (int propertyId : propertyIds) {
                this.engine.comparativeCheck(this.records.propertyKey(propertyId), VALID_PROPERTY_KEY);
            }
        }
    }

    private class ObligationsCheckStrategy
    implements CheckStrategy {
        private ObligationsCheckStrategy() {
        }

        @Override
        public void checkIndexRule(StoreIndexDescriptor rule, DynamicRecord record, RecordAccess records, CheckerEngine<DynamicRecord, ConsistencyReport.SchemaConsistencyReport> engine) {
            if (rule.canSupportUniqueConstraint()) {
                DynamicRecord obligation = (DynamicRecord)SchemaRecordCheck.this.indexObligations.get(rule.getId());
                if (obligation == null) {
                    if (rule.getOwningConstraint() != null) {
                        engine.report().missingObligation(SchemaRule.Kind.UNIQUENESS_CONSTRAINT);
                    }
                } else if (obligation.getId() != rule.getOwningConstraint().longValue()) {
                    engine.report().constraintIndexRuleNotReferencingBack(obligation);
                }
            }
            if (SchemaRecordCheck.this.indexAccessors.notOnlineRules().contains(rule)) {
                engine.report().schemaRuleNotOnline((SchemaRule)rule);
            }
        }

        @Override
        public void checkConstraintRule(ConstraintRule rule, DynamicRecord record, RecordAccess records, CheckerEngine<DynamicRecord, ConsistencyReport.SchemaConsistencyReport> engine) {
            if (rule.getConstraintDescriptor().enforcesUniqueness()) {
                DynamicRecord obligation = (DynamicRecord)SchemaRecordCheck.this.constraintObligations.get(rule.getId());
                if (obligation == null) {
                    engine.report().missingObligation(SchemaRule.Kind.CONSTRAINT_INDEX_RULE);
                } else if (obligation.getId() != rule.getOwnedIndex()) {
                    engine.report().uniquenessConstraintNotReferencingBack(obligation);
                }
            }
        }
    }

    private class RulesCheckStrategy
    implements CheckStrategy {
        private RulesCheckStrategy() {
        }

        @Override
        public void checkIndexRule(StoreIndexDescriptor rule, DynamicRecord record, RecordAccess records, CheckerEngine<DynamicRecord, ConsistencyReport.SchemaConsistencyReport> engine) {
            DynamicRecord previousObligation;
            SchemaRecordCheck.this.checkSchema((SchemaRule)rule, record, records, engine);
            if (rule.canSupportUniqueConstraint() && rule.getOwningConstraint() != null && (previousObligation = (DynamicRecord)SchemaRecordCheck.this.constraintObligations.put(rule.getOwningConstraint(), SchemaRecordCheck.this.cloneRecord((AbstractBaseRecord)record))) != null) {
                engine.report().duplicateObligation(previousObligation);
            }
        }

        @Override
        public void checkConstraintRule(ConstraintRule rule, DynamicRecord record, RecordAccess records, CheckerEngine<DynamicRecord, ConsistencyReport.SchemaConsistencyReport> engine) {
            DynamicRecord previousObligation;
            SchemaRecordCheck.this.checkSchema((SchemaRule)rule, record, records, engine);
            if (rule.getConstraintDescriptor().enforcesUniqueness() && (previousObligation = (DynamicRecord)SchemaRecordCheck.this.indexObligations.put(rule.getOwnedIndex(), SchemaRecordCheck.this.cloneRecord((AbstractBaseRecord)record))) != null) {
                engine.report().duplicateObligation(previousObligation);
            }
        }
    }

    private static interface CheckStrategy {
        public void checkIndexRule(StoreIndexDescriptor var1, DynamicRecord var2, RecordAccess var3, CheckerEngine<DynamicRecord, ConsistencyReport.SchemaConsistencyReport> var4);

        public void checkConstraintRule(ConstraintRule var1, DynamicRecord var2, RecordAccess var3, CheckerEngine<DynamicRecord, ConsistencyReport.SchemaConsistencyReport> var4);
    }
}

