/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.repair;

import java.util.Iterator;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.impl.map.mutable.primitive.LongObjectHashMap;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;

class RecordSet<R extends AbstractBaseRecord>
implements Iterable<R> {
    private final MutableLongObjectMap<R> map = new LongObjectHashMap();

    RecordSet() {
    }

    void add(R record) {
        this.map.put(record.getId(), record);
    }

    RecordSet<R> union(RecordSet<R> other) {
        RecordSet<R> set = new RecordSet<R>();
        set.addAll(this);
        set.addAll(other);
        return set;
    }

    int size() {
        return this.map.size();
    }

    @Override
    public Iterator<R> iterator() {
        return this.map.iterator();
    }

    public void addAll(RecordSet<R> other) {
        this.map.putAll(other.map);
    }

    public boolean containsAll(RecordSet<R> other) {
        return this.map.keySet().containsAll((LongIterable)other.map.keySet());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[\n");
        for (AbstractBaseRecord r : this.map.values()) {
            builder.append(r.toString()).append(",\n");
        }
        return builder.append("]\n").toString();
    }
}

