/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms;

import java.io.Closeable;
import java.io.File;
import java.nio.file.Path;
import java.util.function.Consumer;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.arguments.Arguments;
import org.neo4j.commandline.arguments.NamedArgument;
import org.neo4j.commandline.arguments.common.MandatoryCanonicalPath;
import org.neo4j.commandline.dbms.StoreLockChecker;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.impl.muninn.StandalonePageCacheFactory;
import org.neo4j.kernel.StoreLockException;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.storemigration.StoreVersionCheck;
import org.neo4j.kernel.impl.util.Validators;
import org.neo4j.scheduler.JobScheduler;

public class StoreInfoCommand
implements AdminCommand {
    private static final Arguments arguments = new Arguments().withArgument((NamedArgument)new MandatoryCanonicalPath("store", "path-to-dir", "Path to database store."));
    private Consumer<String> out;

    public StoreInfoCommand(Consumer<String> out) {
        this.out = out;
    }

    public void execute(String[] args) throws IncorrectUsage, CommandFailed {
        Path databaseDirectory = arguments.parse(args).getMandatoryPath("store");
        Validators.CONTAINS_EXISTING_DATABASE.validate((Object)databaseDirectory.toFile());
        DatabaseLayout databaseLayout = DatabaseLayout.of((File)databaseDirectory.toFile());
        try (Closeable ignored = StoreLockChecker.check(databaseLayout.getStoreLayout());
             DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();
             JobScheduler jobScheduler = JobSchedulerFactory.createInitialisedScheduler();
             PageCache pageCache = StandalonePageCacheFactory.createPageCache((FileSystemAbstraction)fileSystem, (JobScheduler)jobScheduler);){
            String storeVersion = (String)new StoreVersionCheck(pageCache).getVersion(databaseLayout.metadataStore()).orElseThrow(() -> new CommandFailed(String.format("Could not find version metadata in store '%s'", databaseDirectory)));
            String fmt = "%-30s%s";
            this.out.accept(String.format("%-30s%s", "Store format version:", storeVersion));
            RecordFormats format = RecordFormatSelector.selectForVersion((String)storeVersion);
            this.out.accept(String.format("%-30s%s", "Store format introduced in:", format.introductionVersion()));
            RecordFormatSelector.findSuccessor((RecordFormats)format).map(next -> String.format("%-30s%s", "Store format superseded in:", next.introductionVersion())).ifPresent(this.out);
        }
        catch (StoreLockException e) {
            throw new CommandFailed("the database is in use -- stop Neo4j and try again", (Throwable)e);
        }
        catch (Exception e) {
            throw new CommandFailed(e.getMessage(), (Throwable)e);
        }
    }

    public static Arguments arguments() {
        return arguments;
    }
}

