/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.diagnostics.jmx;

import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import java.io.IOException;
import java.util.Properties;

public class LocalVirtualMachine {
    private final String address;
    private final Properties systemProperties;

    private LocalVirtualMachine(String address, Properties systemProperties) {
        this.address = address;
        this.systemProperties = systemProperties;
    }

    public String getJmxAddress() {
        return this.address;
    }

    public Properties getSystemProperties() {
        return this.systemProperties;
    }

    public static LocalVirtualMachine from(long pid) throws IOException {
        VirtualMachine vm = null;
        try {
            vm = VirtualMachine.attach(String.valueOf(pid));
            Properties agentProps = vm.getAgentProperties();
            String address = (String)agentProps.get("com.sun.management.jmxremote.localConnectorAddress");
            if (address == null) {
                address = vm.startLocalManagementAgent();
            }
            LocalVirtualMachine localVirtualMachine = new LocalVirtualMachine(address, vm.getSystemProperties());
            return localVirtualMachine;
        }
        catch (AttachNotSupportedException x) {
            throw new IOException(x.getMessage(), x);
        }
        catch (Exception e) {
            if (e.getClass().getCanonicalName().equals("com.ibm.tools.attach.AttachNotSupportedException")) {
                throw new IOException(e);
            }
            throw e;
        }
        finally {
            if (vm != null) {
                vm.detach();
            }
        }
    }
}

