/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.mutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.iterator.FloatIterator;
import org.eclipse.collections.api.list.primitive.FloatList;
import org.eclipse.collections.api.list.primitive.MutableFloatList;
import org.eclipse.collections.api.stack.MutableStack;
import org.eclipse.collections.api.stack.primitive.ImmutableFloatStack;
import org.eclipse.collections.api.stack.primitive.MutableFloatStack;
import org.eclipse.collections.impl.factory.primitive.FloatStacks;
import org.eclipse.collections.impl.list.mutable.primitive.FloatArrayList;
import org.eclipse.collections.impl.stack.mutable.ArrayStack;
import org.eclipse.collections.impl.stack.mutable.primitive.SynchronizedFloatStack;
import org.eclipse.collections.impl.stack.mutable.primitive.UnmodifiableFloatStack;
import org.eclipse.collections.impl.stack.primitive.AbstractFloatStack;

public class FloatArrayStack
extends AbstractFloatStack
implements MutableFloatStack,
Externalizable {
    private static final long serialVersionUID = 1L;
    private transient FloatArrayList delegate;

    public FloatArrayStack() {
        this.delegate = new FloatArrayList();
    }

    private FloatArrayStack(int size) {
        this.delegate = new FloatArrayList(size);
    }

    private FloatArrayStack(float ... items) {
        this.delegate = new FloatArrayList(items);
    }

    public static FloatArrayStack newStackFromTopToBottom(float ... items) {
        FloatArrayStack stack = new FloatArrayStack(items.length);
        for (int i = items.length - 1; i >= 0; --i) {
            stack.push(items[i]);
        }
        return stack;
    }

    public static FloatArrayStack newStackWith(float ... items) {
        return new FloatArrayStack(items);
    }

    public static FloatArrayStack newStack(FloatIterable items) {
        FloatArrayStack stack = new FloatArrayStack(items.size());
        stack.delegate = FloatArrayList.newList(items);
        return stack;
    }

    public static FloatArrayStack newStackFromTopToBottom(FloatIterable items) {
        FloatArrayStack stack = new FloatArrayStack(items.size());
        stack.delegate = FloatArrayList.newList(items).reverseThis();
        return stack;
    }

    @Override
    protected FloatArrayList getDelegate() {
        return this.delegate;
    }

    public void push(float item) {
        this.delegate.add(item);
    }

    public float pop() {
        this.checkEmptyStack();
        return this.delegate.removeAtIndex(this.delegate.size() - 1);
    }

    public FloatList pop(int count) {
        this.checkPositiveValueForCount(count);
        this.checkSizeLessThanCount(count);
        if (count == 0) {
            return new FloatArrayList(0);
        }
        FloatArrayList subList = new FloatArrayList(count);
        while (count > 0) {
            subList.add(this.pop());
            --count;
        }
        return subList;
    }

    public MutableFloatStack select(FloatPredicate predicate) {
        return FloatArrayStack.newStackFromTopToBottom((FloatIterable)this.delegate.asReversed().select(predicate));
    }

    public MutableFloatStack reject(FloatPredicate predicate) {
        return FloatArrayStack.newStackFromTopToBottom((FloatIterable)this.delegate.asReversed().reject(predicate));
    }

    public <V> MutableStack<V> collect(FloatToObjectFunction<? extends V> function) {
        return ArrayStack.newStackFromTopToBottom(this.delegate.asReversed().collect(function));
    }

    public void clear() {
        this.delegate.clear();
    }

    public MutableFloatList toSortedList() {
        return FloatArrayList.newList((FloatIterable)this).sortThis();
    }

    public MutableFloatStack asUnmodifiable() {
        return new UnmodifiableFloatStack(this);
    }

    public MutableFloatStack asSynchronized() {
        return new SynchronizedFloatStack(this);
    }

    public ImmutableFloatStack toImmutable() {
        return FloatStacks.immutable.withAll((FloatIterable)this.delegate);
    }

    public FloatArrayStack newEmpty() {
        return new FloatArrayStack();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        FloatIterator iterator = this.delegate.asReversed().floatIterator();
        while (iterator.hasNext()) {
            float each = iterator.next();
            out.writeFloat(each);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int size = in.readInt();
        float[] array = new float[size];
        for (int i = size - 1; i >= 0; --i) {
            array[i] = in.readFloat();
        }
        this.delegate = FloatArrayList.newListWith(array);
    }
}

