/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.mutable.primitive;

import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.factory.stack.primitive.MutableCharStackFactory;
import org.eclipse.collections.api.stack.primitive.MutableCharStack;
import org.eclipse.collections.impl.stack.mutable.primitive.CharArrayStack;

public enum MutableCharStackFactoryImpl implements MutableCharStackFactory
{
    INSTANCE;


    public MutableCharStack empty() {
        return new CharArrayStack();
    }

    public MutableCharStack of() {
        return this.empty();
    }

    public MutableCharStack with() {
        return this.empty();
    }

    public MutableCharStack of(char ... items) {
        return this.with(items);
    }

    public MutableCharStack with(char ... items) {
        if (items.length == 0) {
            return this.empty();
        }
        return CharArrayStack.newStackWith(items);
    }

    public MutableCharStack ofAll(CharIterable items) {
        return this.withAll(items);
    }

    public MutableCharStack withAll(CharIterable items) {
        if (items.isEmpty()) {
            return this.empty();
        }
        return CharArrayStack.newStack(items);
    }

    public MutableCharStack ofAllReversed(CharIterable items) {
        return this.withAllReversed(items);
    }

    public MutableCharStack withAllReversed(CharIterable items) {
        if (items.isEmpty()) {
            return this.empty();
        }
        return CharArrayStack.newStackFromTopToBottom(items);
    }
}

