/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.mutable.primitive;

import java.io.Serializable;
import java.util.Collection;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.block.function.primitive.CharIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.CharToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectCharIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.api.block.procedure.primitive.CharIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.iterator.CharIterator;
import org.eclipse.collections.api.list.primitive.CharList;
import org.eclipse.collections.api.list.primitive.MutableCharList;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.api.stack.MutableStack;
import org.eclipse.collections.api.stack.primitive.ImmutableCharStack;
import org.eclipse.collections.api.stack.primitive.MutableCharStack;
import org.eclipse.collections.impl.factory.primitive.CharStacks;
import org.eclipse.collections.impl.iterator.UnmodifiableCharIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import org.eclipse.collections.impl.stack.mutable.primitive.SynchronizedCharStack;

public class UnmodifiableCharStack
implements MutableCharStack,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableCharStack stack;

    public UnmodifiableCharStack(MutableCharStack stack) {
        this.stack = stack;
    }

    public void push(char item) {
        throw new UnsupportedOperationException("Cannot call push() on " + this.getClass().getSimpleName());
    }

    public char pop() {
        throw new UnsupportedOperationException("Cannot call pop() on " + this.getClass().getSimpleName());
    }

    public CharList pop(int count) {
        throw new UnsupportedOperationException("Cannot call pop() on " + this.getClass().getSimpleName());
    }

    public char peek() {
        return this.stack.peek();
    }

    public CharList peek(int count) {
        return this.stack.peek(count);
    }

    public char peekAt(int index) {
        return this.stack.peekAt(index);
    }

    public int size() {
        return this.stack.size();
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    public boolean notEmpty() {
        return this.stack.notEmpty();
    }

    public void clear() {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public boolean contains(char value) {
        return this.stack.contains(value);
    }

    public boolean containsAll(char ... source) {
        return this.stack.containsAll(source);
    }

    public boolean containsAll(CharIterable source) {
        return this.stack.containsAll(source);
    }

    public CharIterator charIterator() {
        return new UnmodifiableCharIterator(this.stack.charIterator());
    }

    public void forEach(CharProcedure procedure) {
        this.each(procedure);
    }

    public void each(CharProcedure procedure) {
        this.stack.forEach(procedure);
    }

    public int count(CharPredicate predicate) {
        return this.stack.count(predicate);
    }

    public boolean anySatisfy(CharPredicate predicate) {
        return this.stack.anySatisfy(predicate);
    }

    public boolean allSatisfy(CharPredicate predicate) {
        return this.stack.allSatisfy(predicate);
    }

    public boolean noneSatisfy(CharPredicate predicate) {
        return this.stack.noneSatisfy(predicate);
    }

    public char detectIfNone(CharPredicate predicate, char ifNone) {
        return this.stack.detectIfNone(predicate, ifNone);
    }

    public MutableCharStack select(CharPredicate predicate) {
        return this.stack.select(predicate);
    }

    public MutableCharStack reject(CharPredicate predicate) {
        return this.stack.reject(predicate);
    }

    public <V> MutableStack<V> collect(CharToObjectFunction<? extends V> function) {
        return this.stack.collect(function);
    }

    public long sum() {
        return this.stack.sum();
    }

    public char max() {
        return this.stack.max();
    }

    public char min() {
        return this.stack.min();
    }

    public char minIfEmpty(char defaultValue) {
        return this.stack.minIfEmpty(defaultValue);
    }

    public char maxIfEmpty(char defaultValue) {
        return this.stack.maxIfEmpty(defaultValue);
    }

    public double average() {
        return this.stack.average();
    }

    public double median() {
        return this.stack.median();
    }

    public MutableCharList toSortedList() {
        return this.stack.toSortedList();
    }

    public char[] toSortedArray() {
        return this.stack.toSortedArray();
    }

    public char[] toArray() {
        return this.stack.toArray();
    }

    public String toString() {
        return this.stack.toString();
    }

    public String makeString() {
        return this.stack.makeString();
    }

    public String makeString(String separator) {
        return this.stack.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.stack.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.stack.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.stack.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.stack.appendString(appendable, start, separator, end);
    }

    public MutableCharList toList() {
        return this.stack.toList();
    }

    public MutableCharSet toSet() {
        return this.stack.toSet();
    }

    public MutableCharBag toBag() {
        return this.stack.toBag();
    }

    public boolean equals(Object otherStack) {
        return this.stack.equals(otherStack);
    }

    public int hashCode() {
        return this.stack.hashCode();
    }

    public LazyCharIterable asLazy() {
        return new LazyCharIterableAdapter((CharIterable)this);
    }

    public MutableCharStack asUnmodifiable() {
        return this;
    }

    public MutableCharStack asSynchronized() {
        return new SynchronizedCharStack(this);
    }

    public ImmutableCharStack toImmutable() {
        return CharStacks.immutable.withAllReversed((CharIterable)this);
    }

    public MutableCharStack newEmpty() {
        return this.stack.newEmpty();
    }

    public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function) {
        return (T)this.stack.injectInto(injectedValue, function);
    }

    public RichIterable<CharIterable> chunk(int size) {
        return this.stack.chunk(size);
    }

    public char getFirst() {
        return this.stack.getFirst();
    }

    public int indexOf(char value) {
        return this.stack.indexOf(value);
    }

    public <T> T injectIntoWithIndex(T injectedValue, ObjectCharIntToObjectFunction<? super T, ? extends T> function) {
        return (T)this.stack.injectIntoWithIndex(injectedValue, function);
    }

    public void forEachWithIndex(CharIntProcedure procedure) {
        this.stack.forEachWithIndex(procedure);
    }

    public <V> MutableStack<V> collectWithIndex(CharIntToObjectFunction<? extends V> function) {
        return this.stack.collectWithIndex(function);
    }

    public <V, R extends Collection<V>> R collectWithIndex(CharIntToObjectFunction<? extends V> function, R target) {
        return (R)this.stack.collectWithIndex(function, target);
    }
}

