/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.utils;

import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;

public final class TemporalUtil {
    public static final long NANOS_PER_SECOND = 1000000000L;
    public static final long AVG_NANOS_PER_MONTH = 2629746000000000L;
    public static final long SECONDS_PER_DAY = ChronoUnit.DAYS.getDuration().getSeconds();
    public static final long AVG_SECONDS_PER_MONTH = 2629746L;
    public static final double AVG_DAYS_PER_MONTH = 30.436875;

    private TemporalUtil() {
    }

    public static OffsetTime truncateOffsetToMinutes(OffsetTime value) {
        int offsetMinutes = value.getOffset().getTotalSeconds() / 60;
        ZoneOffset truncatedOffset = ZoneOffset.ofTotalSeconds(offsetMinutes * 60);
        return value.withOffsetSameInstant(truncatedOffset);
    }

    public static long nanosOfDayToUTC(long nanosOfDayLocal, int offsetSeconds) {
        return nanosOfDayLocal - (long)offsetSeconds * 1000000000L;
    }

    public static long nanosOfDayToLocal(long nanosOfDayUTC, int offsetSeconds) {
        return nanosOfDayUTC + (long)offsetSeconds * 1000000000L;
    }

    public static long getNanosOfDayUTC(OffsetTime value) {
        long secondsOfDayLocal = value.toLocalTime().toSecondOfDay();
        long secondsOffset = value.getOffset().getTotalSeconds();
        return (secondsOfDayLocal - secondsOffset) * 1000000000L + (long)value.getNano();
    }
}

