/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.facade;

import java.io.File;
import java.time.Clock;
import java.util.Map;
import java.util.function.Function;
import org.neo4j.bolt.BoltServer;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.factory.module.PlatformModule;
import org.neo4j.graphdb.factory.module.edition.AbstractEditionModule;
import org.neo4j.graphdb.security.URLAccessRule;
import org.neo4j.graphdb.spatial.Geometry;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.internal.DataCollectorManager;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.proc.Context;
import org.neo4j.kernel.api.security.provider.SecurityProvider;
import org.neo4j.kernel.availability.AvailabilityGuardInstaller;
import org.neo4j.kernel.availability.StartupWaiter;
import org.neo4j.kernel.builtinprocs.SpecialBuiltInProcedures;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.api.dbms.NonTransactionalDbmsOperations;
import org.neo4j.kernel.impl.cache.VmPauseMonitorComponent;
import org.neo4j.kernel.impl.core.EmbeddedProxySPI;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.pagecache.PublishPageCacheTracerMetricsAfterStart;
import org.neo4j.kernel.impl.proc.ComponentRegistry;
import org.neo4j.kernel.impl.proc.ProcedureConfig;
import org.neo4j.kernel.impl.proc.ProcedureTransactionProvider;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.proc.TerminationGuardProvider;
import org.neo4j.kernel.impl.query.QueryEngineProvider;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.internal.Version;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.Logger;
import org.neo4j.procedure.ProcedureTransaction;
import org.neo4j.procedure.TerminationGuard;
import org.neo4j.scheduler.DeferredExecutor;
import org.neo4j.scheduler.Group;

public class GraphDatabaseFacadeFactory {
    protected final DatabaseInfo databaseInfo;
    private final Function<PlatformModule, AbstractEditionModule> editionFactory;

    public GraphDatabaseFacadeFactory(DatabaseInfo databaseInfo, Function<PlatformModule, AbstractEditionModule> editionFactory) {
        this.databaseInfo = databaseInfo;
        this.editionFactory = editionFactory;
    }

    public GraphDatabaseFacade newFacade(File storeDir, Config config, Dependencies dependencies) {
        return this.initFacade(storeDir, config, dependencies, new GraphDatabaseFacade());
    }

    public GraphDatabaseFacade initFacade(File storeDir, Map<String, String> params, Dependencies dependencies, GraphDatabaseFacade graphDatabaseFacade) {
        return this.initFacade(storeDir, Config.defaults(params), dependencies, graphDatabaseFacade);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GraphDatabaseFacade initFacade(File storeDir, Config config, Dependencies dependencies, GraphDatabaseFacade graphDatabaseFacade) {
        PlatformModule platform = this.createPlatform(storeDir, config, dependencies);
        AbstractEditionModule edition = this.editionFactory.apply(platform);
        dependencies.availabilityGuardInstaller().install(edition.getGlobalAvailabilityGuard((Clock)platform.clock, platform.logging, platform.config));
        platform.life.add((Lifecycle)new VmPauseMonitorComponent(config, platform.logging.getInternalLog(VmPauseMonitorComponent.class), platform.jobScheduler));
        Procedures procedures = GraphDatabaseFacadeFactory.setupProcedures(platform, edition, graphDatabaseFacade);
        platform.dependencies.satisfyDependency((Object)new NonTransactionalDbmsOperations(procedures));
        Logger msgLog = platform.logging.getInternalLog(this.getClass()).infoLogger();
        DatabaseManager databaseManager = edition.createDatabaseManager(graphDatabaseFacade, platform, edition, procedures, msgLog);
        platform.life.add((Lifecycle)databaseManager);
        platform.dependencies.satisfyDependency((Object)databaseManager);
        DataCollectorManager dataCollectorManager = new DataCollectorManager(platform.dataSourceManager, platform.jobScheduler, procedures, platform.monitors, platform.config);
        platform.life.add((Lifecycle)dataCollectorManager);
        edition.createSecurityModule(platform, procedures);
        SecurityProvider securityProvider = edition.getSecurityProvider();
        platform.dependencies.satisfyDependencies(new Object[]{securityProvider.authManager()});
        platform.dependencies.satisfyDependencies(new Object[]{securityProvider.userManagerSupplier()});
        platform.life.add((Lifecycle)platform.globalKernelExtensions);
        platform.life.add((Lifecycle)GraphDatabaseFacadeFactory.createBoltServer(platform, edition, databaseManager));
        platform.dependencies.satisfyDependency((Object)edition.globalTransactionCounter());
        platform.life.add((Lifecycle)new PublishPageCacheTracerMetricsAfterStart(platform.tracers.pageCursorTracerSupplier));
        platform.life.add((Lifecycle)new StartupWaiter(edition.getGlobalAvailabilityGuard((Clock)platform.clock, platform.logging, platform.config), edition.getTransactionStartTimeout()));
        platform.dependencies.satisfyDependency((Object)edition.getSchemaWriteGuard());
        platform.life.setLast((Lifecycle)platform.eventHandlers);
        edition.createDatabases(databaseManager, config);
        String activeDatabase = (String)config.get(GraphDatabaseSettings.active_database);
        GraphDatabaseFacade databaseFacade = (GraphDatabaseFacade)databaseManager.getDatabaseFacade(activeDatabase).orElseThrow(() -> new IllegalStateException(String.format("Database %s not found. Please check the logs for startup errors.", activeDatabase)));
        Throwable error = null;
        try {
            platform.life.start();
        }
        catch (Throwable throwable) {
            error = new RuntimeException("Error starting " + this.getClass().getName() + ", " + platform.storeLayout.storeDirectory(), throwable);
        }
        finally {
            if (error != null) {
                try {
                    graphDatabaseFacade.shutdown();
                }
                catch (Throwable shutdownError) {
                    error.addSuppressed(shutdownError);
                }
            }
        }
        if (error != null) {
            msgLog.log("Failed to start database", error);
            throw error;
        }
        return databaseFacade;
    }

    protected PlatformModule createPlatform(File storeDir, Config config, Dependencies dependencies) {
        return new PlatformModule(storeDir, config, this.databaseInfo, dependencies);
    }

    private static Procedures setupProcedures(PlatformModule platform, AbstractEditionModule editionModule, GraphDatabaseFacade facade) {
        File pluginDir = (File)platform.config.get(GraphDatabaseSettings.plugin_dir);
        Log internalLog = platform.logging.getInternalLog(Procedures.class);
        ProcedureConfig procedureConfig = new ProcedureConfig(platform.config);
        Procedures procedures = new Procedures((EmbeddedProxySPI)facade, (ThrowingConsumer)new SpecialBuiltInProcedures(Version.getNeo4jVersion(), platform.databaseInfo.edition.toString()), pluginDir, internalLog, procedureConfig);
        platform.life.add((Lifecycle)procedures);
        platform.dependencies.satisfyDependency((Object)procedures);
        procedures.registerType(Node.class, (Neo4jTypes.AnyType)Neo4jTypes.NTNode);
        procedures.registerType(Relationship.class, (Neo4jTypes.AnyType)Neo4jTypes.NTRelationship);
        procedures.registerType(Path.class, (Neo4jTypes.AnyType)Neo4jTypes.NTPath);
        procedures.registerType(Geometry.class, (Neo4jTypes.AnyType)Neo4jTypes.NTGeometry);
        procedures.registerType(Point.class, (Neo4jTypes.AnyType)Neo4jTypes.NTPoint);
        Log proceduresLog = platform.logging.getUserLog(Procedures.class);
        procedures.registerComponent(Log.class, ctx -> proceduresLog, true);
        procedures.registerComponent(ProcedureTransaction.class, (ComponentRegistry.Provider)new ProcedureTransactionProvider(), true);
        procedures.registerComponent(TerminationGuard.class, (ComponentRegistry.Provider)new TerminationGuardProvider(), true);
        procedures.registerComponent(DependencyResolver.class, ctx -> (DependencyResolver)ctx.get(Context.DEPENDENCY_RESOLVER), false);
        procedures.registerComponent(KernelTransaction.class, ctx -> (KernelTransaction)ctx.get(Context.KERNEL_TRANSACTION), false);
        procedures.registerComponent(GraphDatabaseAPI.class, ctx -> (GraphDatabaseAPI)ctx.get(Context.DATABASE_API), false);
        procedures.registerComponent(SecurityContext.class, ctx -> (SecurityContext)ctx.get(Context.SECURITY_CONTEXT), true);
        procedures.registerComponent(ProcedureCallContext.class, ctx -> (ProcedureCallContext)ctx.get(Context.PROCEDURE_CALL_CONTEXT), true);
        try {
            editionModule.registerProcedures(procedures, procedureConfig);
        }
        catch (KernelException e) {
            internalLog.error("Failed to register built-in edition procedures at start up: " + e.getMessage());
        }
        return procedures;
    }

    private static BoltServer createBoltServer(PlatformModule platform, AbstractEditionModule edition, DatabaseManager databaseManager) {
        return new BoltServer(databaseManager, platform.jobScheduler, platform.connectorPortRegister, edition.getConnectionTracker(), platform.usageData, platform.config, (Clock)platform.clock, platform.monitors, platform.logging, (DependencyResolver)platform.dependencies);
    }

    public static interface Dependencies {
        public Monitors monitors();

        public LogProvider userLogProvider();

        public Iterable<Class<?>> settingsClasses();

        public Iterable<KernelExtensionFactory<?>> kernelExtensions();

        public Map<String, URLAccessRule> urlAccessRules();

        public Iterable<QueryEngineProvider> executionEngines();

        public Iterable<Pair<DeferredExecutor, Group>> deferredExecutors();

        default public AvailabilityGuardInstaller availabilityGuardInstaller() {
            return availabilityGuard -> {};
        }
    }
}

