/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory.module;

import java.io.File;
import java.time.Clock;
import java.time.Duration;
import java.util.function.Function;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.factory.module.PlatformModule;
import org.neo4j.graphdb.factory.module.edition.context.DatabaseEditionContext;
import org.neo4j.graphdb.factory.module.id.DatabaseIdContext;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;
import org.neo4j.kernel.DatabaseCreationContext;
import org.neo4j.kernel.api.explicitindex.AutoIndexing;
import org.neo4j.kernel.availability.AvailabilityGuard;
import org.neo4j.kernel.availability.DatabaseAvailability;
import org.neo4j.kernel.availability.DatabaseAvailabilityGuard;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.api.CommitProcessFactory;
import org.neo4j.kernel.impl.api.DefaultExplicitIndexProvider;
import org.neo4j.kernel.impl.api.ExplicitIndexProvider;
import org.neo4j.kernel.impl.api.NonTransactionalTokenNameLookup;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.api.explicitindex.InternalAutoIndexing;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.core.EmbeddedProxySPI;
import org.neo4j.kernel.impl.core.TokenHolders;
import org.neo4j.kernel.impl.coreapi.CoreAPIAvailabilityGuard;
import org.neo4j.kernel.impl.factory.AccessCapability;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.StatementLocksFactory;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.query.QueryEngineProvider;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.id.IdController;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.transaction.TransactionHeaderInformationFactory;
import org.neo4j.kernel.impl.transaction.TransactionMonitor;
import org.neo4j.kernel.impl.transaction.log.checkpoint.StoreCopyCheckPointMutex;
import org.neo4j.kernel.impl.transaction.log.files.LogFileCreationMonitor;
import org.neo4j.kernel.impl.transaction.stats.DatabaseTransactionStats;
import org.neo4j.kernel.impl.transaction.stats.TransactionCounters;
import org.neo4j.kernel.impl.util.collection.CollectionsFactorySupplier;
import org.neo4j.kernel.impl.util.watcher.FileSystemWatcherService;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.kernel.internal.TransactionEventHandlers;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.kernel.monitoring.tracing.Tracers;
import org.neo4j.logging.internal.LogService;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.time.SystemNanoClock;

public class ModularDatabaseCreationContext
implements DatabaseCreationContext {
    private final String databaseName;
    private final Config config;
    private final IdGeneratorFactory idGeneratorFactory;
    private final LogService logService;
    private final JobScheduler scheduler;
    private final TokenNameLookup tokenNameLookup;
    private final DependencyResolver globalDependencies;
    private final TokenHolders tokenHolders;
    private final Locks locks;
    private final StatementLocksFactory statementLocksFactory;
    private final SchemaWriteGuard schemaWriteGuard;
    private final TransactionEventHandlers transactionEventHandlers;
    private final IndexingService.Monitor indexingServiceMonitor;
    private final FileSystemAbstraction fs;
    private final DatabaseTransactionStats transactionStats;
    private final DatabaseHealth databaseHealth;
    private final LogFileCreationMonitor physicalLogMonitor;
    private final TransactionHeaderInformationFactory transactionHeaderInformationFactory;
    private final CommitProcessFactory commitProcessFactory;
    private final AutoIndexing autoIndexing;
    private final IndexConfigStore indexConfigStore;
    private final ExplicitIndexProvider explicitIndexProvider;
    private final PageCache pageCache;
    private final ConstraintSemantics constraintSemantics;
    private final Monitors monitors;
    private final Tracers tracers;
    private final Procedures procedures;
    private final IOLimiter ioLimiter;
    private final DatabaseAvailabilityGuard databaseAvailabilityGuard;
    private final CoreAPIAvailabilityGuard coreAPIAvailabilityGuard;
    private final SystemNanoClock clock;
    private final AccessCapability accessCapability;
    private final StoreCopyCheckPointMutex storeCopyCheckPointMutex;
    private final RecoveryCleanupWorkCollector recoveryCleanupWorkCollector;
    private final IdController idController;
    private final DatabaseInfo databaseInfo;
    private final VersionContextSupplier versionContextSupplier;
    private final CollectionsFactorySupplier collectionsFactorySupplier;
    private final Iterable<KernelExtensionFactory<?>> kernelExtensionFactories;
    private final Function<File, FileSystemWatcherService> watcherServiceFactory;
    private final GraphDatabaseFacade facade;
    private final Iterable<QueryEngineProvider> engineProviders;
    private final DatabaseLayout databaseLayout;
    private final DatabaseAvailability databaseAvailability;

    ModularDatabaseCreationContext(String databaseName, PlatformModule platformModule, DatabaseEditionContext editionContext, Procedures procedures, GraphDatabaseFacade facade) {
        this.databaseName = databaseName;
        this.config = platformModule.config;
        DatabaseIdContext idContext = editionContext.getIdContext();
        this.idGeneratorFactory = idContext.getIdGeneratorFactory();
        this.idController = idContext.getIdController();
        this.databaseLayout = platformModule.storeLayout.databaseLayout(databaseName);
        this.logService = platformModule.logging;
        this.scheduler = platformModule.jobScheduler;
        this.globalDependencies = platformModule.dependencies;
        this.tokenHolders = editionContext.createTokenHolders();
        this.tokenNameLookup = new NonTransactionalTokenNameLookup(this.tokenHolders);
        this.locks = editionContext.createLocks();
        this.statementLocksFactory = editionContext.createStatementLocksFactory();
        this.schemaWriteGuard = editionContext.getSchemaWriteGuard();
        this.transactionEventHandlers = new TransactionEventHandlers((EmbeddedProxySPI)facade);
        this.monitors = new Monitors(platformModule.monitors);
        this.indexingServiceMonitor = (IndexingService.Monitor)this.monitors.newMonitor(IndexingService.Monitor.class, new String[0]);
        this.physicalLogMonitor = (LogFileCreationMonitor)this.monitors.newMonitor(LogFileCreationMonitor.class, new String[0]);
        this.fs = platformModule.fileSystem;
        this.transactionStats = editionContext.createTransactionMonitor();
        this.databaseHealth = new DatabaseHealth(platformModule.panicEventGenerator, this.logService.getInternalLog(DatabaseHealth.class));
        this.transactionHeaderInformationFactory = editionContext.getHeaderInformationFactory();
        this.commitProcessFactory = editionContext.getCommitProcessFactory();
        this.autoIndexing = new InternalAutoIndexing(platformModule.config, this.tokenHolders.propertyKeyTokens());
        this.indexConfigStore = new IndexConfigStore(this.databaseLayout, this.fs);
        this.explicitIndexProvider = new DefaultExplicitIndexProvider();
        this.pageCache = platformModule.pageCache;
        this.constraintSemantics = editionContext.getConstraintSemantics();
        this.tracers = platformModule.tracers;
        this.procedures = procedures;
        this.ioLimiter = editionContext.getIoLimiter();
        this.clock = platformModule.clock;
        this.databaseAvailabilityGuard = editionContext.createDatabaseAvailabilityGuard(this.clock, this.logService, this.config);
        this.databaseAvailability = new DatabaseAvailability((AvailabilityGuard)this.databaseAvailabilityGuard, (TransactionCounters)this.transactionStats, (Clock)platformModule.clock, this.getAwaitActiveTransactionDeadlineMillis());
        this.coreAPIAvailabilityGuard = new CoreAPIAvailabilityGuard(this.databaseAvailabilityGuard, editionContext.getTransactionStartTimeout());
        this.accessCapability = editionContext.getAccessCapability();
        this.storeCopyCheckPointMutex = new StoreCopyCheckPointMutex();
        this.recoveryCleanupWorkCollector = platformModule.recoveryCleanupWorkCollector;
        this.databaseInfo = platformModule.databaseInfo;
        this.versionContextSupplier = platformModule.versionContextSupplier;
        this.collectionsFactorySupplier = platformModule.collectionsFactorySupplier;
        this.kernelExtensionFactories = platformModule.kernelExtensionFactories;
        this.watcherServiceFactory = editionContext.getWatcherServiceFactory();
        this.facade = facade;
        this.engineProviders = platformModule.engineProviders;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public DatabaseLayout getDatabaseLayout() {
        return this.databaseLayout;
    }

    public Config getConfig() {
        return this.config;
    }

    public IdGeneratorFactory getIdGeneratorFactory() {
        return this.idGeneratorFactory;
    }

    public LogService getLogService() {
        return this.logService;
    }

    public JobScheduler getScheduler() {
        return this.scheduler;
    }

    public TokenNameLookup getTokenNameLookup() {
        return this.tokenNameLookup;
    }

    public DependencyResolver getGlobalDependencies() {
        return this.globalDependencies;
    }

    public TokenHolders getTokenHolders() {
        return this.tokenHolders;
    }

    public Locks getLocks() {
        return this.locks;
    }

    public StatementLocksFactory getStatementLocksFactory() {
        return this.statementLocksFactory;
    }

    public SchemaWriteGuard getSchemaWriteGuard() {
        return this.schemaWriteGuard;
    }

    public TransactionEventHandlers getTransactionEventHandlers() {
        return this.transactionEventHandlers;
    }

    public IndexingService.Monitor getIndexingServiceMonitor() {
        return this.indexingServiceMonitor;
    }

    public FileSystemAbstraction getFs() {
        return this.fs;
    }

    public TransactionMonitor getTransactionMonitor() {
        return this.transactionStats;
    }

    public DatabaseHealth getDatabaseHealth() {
        return this.databaseHealth;
    }

    public LogFileCreationMonitor getPhysicalLogMonitor() {
        return this.physicalLogMonitor;
    }

    public TransactionHeaderInformationFactory getTransactionHeaderInformationFactory() {
        return this.transactionHeaderInformationFactory;
    }

    public CommitProcessFactory getCommitProcessFactory() {
        return this.commitProcessFactory;
    }

    public AutoIndexing getAutoIndexing() {
        return this.autoIndexing;
    }

    public IndexConfigStore getIndexConfigStore() {
        return this.indexConfigStore;
    }

    public ExplicitIndexProvider getExplicitIndexProvider() {
        return this.explicitIndexProvider;
    }

    public PageCache getPageCache() {
        return this.pageCache;
    }

    public ConstraintSemantics getConstraintSemantics() {
        return this.constraintSemantics;
    }

    public Monitors getMonitors() {
        return this.monitors;
    }

    public Tracers getTracers() {
        return this.tracers;
    }

    public Procedures getProcedures() {
        return this.procedures;
    }

    public IOLimiter getIoLimiter() {
        return this.ioLimiter;
    }

    public DatabaseAvailabilityGuard getDatabaseAvailabilityGuard() {
        return this.databaseAvailabilityGuard;
    }

    public CoreAPIAvailabilityGuard getCoreAPIAvailabilityGuard() {
        return this.coreAPIAvailabilityGuard;
    }

    public SystemNanoClock getClock() {
        return this.clock;
    }

    public AccessCapability getAccessCapability() {
        return this.accessCapability;
    }

    public StoreCopyCheckPointMutex getStoreCopyCheckPointMutex() {
        return this.storeCopyCheckPointMutex;
    }

    public RecoveryCleanupWorkCollector getRecoveryCleanupWorkCollector() {
        return this.recoveryCleanupWorkCollector;
    }

    public IdController getIdController() {
        return this.idController;
    }

    public DatabaseInfo getDatabaseInfo() {
        return this.databaseInfo;
    }

    public VersionContextSupplier getVersionContextSupplier() {
        return this.versionContextSupplier;
    }

    public CollectionsFactorySupplier getCollectionsFactorySupplier() {
        return this.collectionsFactorySupplier;
    }

    public Iterable<KernelExtensionFactory<?>> getKernelExtensionFactories() {
        return this.kernelExtensionFactories;
    }

    public Function<File, FileSystemWatcherService> getWatcherServiceFactory() {
        return this.watcherServiceFactory;
    }

    public GraphDatabaseFacade getFacade() {
        return this.facade;
    }

    public Iterable<QueryEngineProvider> getEngineProviders() {
        return this.engineProviders;
    }

    public DatabaseAvailability getDatabaseAvailability() {
        return this.databaseAvailability;
    }

    private long getAwaitActiveTransactionDeadlineMillis() {
        return ((Duration)this.config.get(GraphDatabaseSettings.shutdown_transaction_end_timeout)).toMillis();
    }
}

