/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory.module;

import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import org.neo4j.graphdb.facade.GraphDatabaseFacadeFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.security.URLAccessRule;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.index.internal.gbptree.GroupingRecoveryCleanupWorkCollector;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.diagnostics.DiagnosticsManager;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileSystemLifecycleAdapter;
import org.neo4j.io.layout.StoreLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ConnectorPortRegister;
import org.neo4j.kernel.extension.GlobalKernelExtensions;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.extension.KernelExtensionFailureStrategies;
import org.neo4j.kernel.impl.api.LogRotationMonitor;
import org.neo4j.kernel.impl.context.TransactionVersionContextSupplier;
import org.neo4j.kernel.impl.core.DatabasePanicEventGenerator;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.kernel.impl.pagecache.PageCacheLifecycle;
import org.neo4j.kernel.impl.query.QueryEngineProvider;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.impl.security.URLAccessRules;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.impl.spi.SimpleKernelContext;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointerMonitor;
import org.neo4j.kernel.impl.transaction.state.DataSourceManager;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.impl.util.DependencySatisfier;
import org.neo4j.kernel.impl.util.collection.CachingOffHeapBlockAllocator;
import org.neo4j.kernel.impl.util.collection.CapacityLimitingBlockAllocatorDecorator;
import org.neo4j.kernel.impl.util.collection.CollectionsFactory;
import org.neo4j.kernel.impl.util.collection.CollectionsFactorySupplier;
import org.neo4j.kernel.impl.util.collection.OffHeapBlockAllocator;
import org.neo4j.kernel.impl.util.collection.OffHeapCollectionsFactory;
import org.neo4j.kernel.info.JvmChecker;
import org.neo4j.kernel.info.JvmMetadataRepository;
import org.neo4j.kernel.info.SystemDiagnostics;
import org.neo4j.kernel.internal.KernelEventHandlers;
import org.neo4j.kernel.internal.Version;
import org.neo4j.kernel.internal.locker.GlobalStoreLocker;
import org.neo4j.kernel.internal.locker.StoreLocker;
import org.neo4j.kernel.internal.locker.StoreLockerLifecycleAdapter;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.kernel.monitoring.tracing.Tracers;
import org.neo4j.logging.Level;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.LogTimeZone;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.StoreLogService;
import org.neo4j.scheduler.DeferredExecutor;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.time.Clocks;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.udc.UsageData;
import org.neo4j.udc.UsageDataKeys;

public class PlatformModule {
    public final PageCache pageCache;
    public final Monitors monitors;
    public final Dependencies dependencies;
    public final LogService logging;
    public final LifeSupport life;
    public final StoreLayout storeLayout;
    public final DatabaseInfo databaseInfo;
    public final DiagnosticsManager diagnosticsManager;
    public final KernelEventHandlers eventHandlers;
    public final DatabasePanicEventGenerator panicEventGenerator;
    public final Tracers tracers;
    public final Config config;
    public final FileSystemAbstraction fileSystem;
    public final DataSourceManager dataSourceManager;
    public final GlobalKernelExtensions globalKernelExtensions;
    public final Iterable<KernelExtensionFactory<?>> kernelExtensionFactories;
    public final Iterable<QueryEngineProvider> engineProviders;
    public final URLAccessRule urlAccessRule;
    public final JobScheduler jobScheduler;
    public final SystemNanoClock clock;
    public final VersionContextSupplier versionContextSupplier;
    public final RecoveryCleanupWorkCollector recoveryCleanupWorkCollector;
    public final CollectionsFactorySupplier collectionsFactorySupplier;
    public final UsageData usageData;
    public final ConnectorPortRegister connectorPortRegister;

    public PlatformModule(File providedStoreDir, Config config, DatabaseInfo databaseInfo, GraphDatabaseFacadeFactory.Dependencies externalDependencies) {
        this.databaseInfo = databaseInfo;
        this.dataSourceManager = new DataSourceManager(config);
        this.dependencies = new Dependencies();
        this.dependencies.satisfyDependency((Object)databaseInfo);
        this.clock = (SystemNanoClock)this.dependencies.satisfyDependency((Object)this.createClock());
        this.life = (LifeSupport)this.dependencies.satisfyDependency((Object)this.createLife());
        this.storeLayout = StoreLayout.of((File)providedStoreDir);
        config.augmentDefaults(GraphDatabaseSettings.neo4j_home, this.storeLayout.storeDirectory().getPath());
        this.config = (Config)this.dependencies.satisfyDependency((Object)config);
        this.fileSystem = (FileSystemAbstraction)this.dependencies.satisfyDependency((Object)this.createFileSystemAbstraction());
        this.life.add((Lifecycle)new FileSystemLifecycleAdapter(this.fileSystem));
        this.monitors = externalDependencies.monitors() == null ? new Monitors() : externalDependencies.monitors();
        this.dependencies.satisfyDependency((Object)this.monitors);
        this.jobScheduler = (JobScheduler)this.life.add((Lifecycle)this.dependencies.satisfyDependency((Object)this.createJobScheduler()));
        this.startDeferredExecutors(this.jobScheduler, externalDependencies.deferredExecutors());
        this.recoveryCleanupWorkCollector = new GroupingRecoveryCleanupWorkCollector(this.jobScheduler);
        this.dependencies.satisfyDependency((Object)this.recoveryCleanupWorkCollector);
        this.usageData = new UsageData(this.jobScheduler);
        this.dependencies.satisfyDependency((Object)this.life.add((Lifecycle)this.usageData));
        this.logging = (LogService)this.dependencies.satisfyDependency((Object)this.createLogService(externalDependencies.userLogProvider()));
        config.setLogger(this.logging.getInternalLog(Config.class));
        this.life.add((Lifecycle)this.dependencies.satisfyDependency((Object)new StoreLockerLifecycleAdapter(this.createStoreLocker())));
        new JvmChecker(this.logging.getInternalLog(JvmChecker.class), new JvmMetadataRepository()).checkJvmCompatibilityAndIssueWarning();
        String desiredImplementationName = (String)config.get(GraphDatabaseSettings.tracer);
        this.tracers = (Tracers)this.dependencies.satisfyDependency((Object)new Tracers(desiredImplementationName, this.logging.getInternalLog(Tracers.class), this.monitors, this.jobScheduler, this.clock));
        this.dependencies.satisfyDependency((Object)this.tracers.pageCacheTracer);
        this.dependencies.satisfyDependency((Object)PlatformModule.firstImplementor(LogRotationMonitor.class, this.tracers.transactionTracer, LogRotationMonitor.NULL));
        this.dependencies.satisfyDependency((Object)PlatformModule.firstImplementor(CheckPointerMonitor.class, this.tracers.checkPointTracer, CheckPointerMonitor.NULL));
        this.versionContextSupplier = this.createCursorContextSupplier(config);
        this.collectionsFactorySupplier = PlatformModule.createCollectionsFactorySupplier(config, this.life);
        this.dependencies.satisfyDependency((Object)this.versionContextSupplier);
        this.pageCache = (PageCache)this.dependencies.satisfyDependency((Object)this.createPageCache(this.fileSystem, config, this.logging, this.tracers, this.versionContextSupplier, this.jobScheduler));
        this.life.add((Lifecycle)new PageCacheLifecycle(this.pageCache));
        this.diagnosticsManager = (DiagnosticsManager)this.life.add((Lifecycle)this.dependencies.satisfyDependency((Object)new DiagnosticsManager(this.logging.getInternalLog(DiagnosticsManager.class))));
        SystemDiagnostics.registerWith((DiagnosticsManager)this.diagnosticsManager);
        this.dependencies.satisfyDependency((Object)this.dataSourceManager);
        this.kernelExtensionFactories = externalDependencies.kernelExtensions();
        this.engineProviders = externalDependencies.executionEngines();
        this.globalKernelExtensions = (GlobalKernelExtensions)this.dependencies.satisfyDependency((Object)new GlobalKernelExtensions((KernelContext)new SimpleKernelContext(this.storeLayout.storeDirectory(), databaseInfo, (DependencySatisfier)this.dependencies), this.kernelExtensionFactories, this.dependencies, KernelExtensionFailureStrategies.fail()));
        this.urlAccessRule = (URLAccessRule)this.dependencies.satisfyDependency((Object)URLAccessRules.combined(externalDependencies.urlAccessRules()));
        this.connectorPortRegister = new ConnectorPortRegister();
        this.dependencies.satisfyDependency((Object)this.connectorPortRegister);
        this.eventHandlers = new KernelEventHandlers(this.logging.getInternalLog(KernelEventHandlers.class));
        this.panicEventGenerator = new DatabasePanicEventGenerator(this.eventHandlers);
        PlatformModule.publishPlatformInfo((UsageData)this.dependencies.resolveDependency(UsageData.class));
    }

    private void startDeferredExecutors(JobScheduler jobScheduler, Iterable<Pair<DeferredExecutor, Group>> deferredExecutors) {
        for (Pair<DeferredExecutor, Group> executorGroupPair : deferredExecutors) {
            DeferredExecutor executor = (DeferredExecutor)executorGroupPair.first();
            Group group = (Group)executorGroupPair.other();
            executor.satisfyWith(jobScheduler.executor(group));
        }
    }

    protected VersionContextSupplier createCursorContextSupplier(Config config) {
        return (Boolean)config.get(GraphDatabaseSettings.snapshot_query) != false ? new TransactionVersionContextSupplier() : EmptyVersionContextSupplier.EMPTY;
    }

    protected StoreLocker createStoreLocker() {
        return new GlobalStoreLocker(this.fileSystem, this.storeLayout);
    }

    protected SystemNanoClock createClock() {
        return Clocks.nanoClock();
    }

    private static <T> T firstImplementor(Class<T> type, Object ... candidates) {
        for (Object candidate : candidates) {
            if (!type.isInstance(candidate)) continue;
            return (T)candidate;
        }
        return null;
    }

    private static void publishPlatformInfo(UsageData sysInfo) {
        sysInfo.set(UsageDataKeys.version, (Object)Version.getNeo4jVersion());
        sysInfo.set(UsageDataKeys.revision, (Object)Version.getKernelVersion());
    }

    public LifeSupport createLife() {
        return new LifeSupport();
    }

    protected FileSystemAbstraction createFileSystemAbstraction() {
        return new DefaultFileSystemAbstraction();
    }

    protected LogService createLogService(LogProvider userLogProvider) {
        StoreLogService logService;
        long internalLogRotationThreshold = (Long)this.config.get(GraphDatabaseSettings.store_internal_log_rotation_threshold);
        long internalLogRotationDelay = ((Duration)this.config.get(GraphDatabaseSettings.store_internal_log_rotation_delay)).toMillis();
        int internalLogMaxArchives = (Integer)this.config.get(GraphDatabaseSettings.store_internal_log_max_archives);
        StoreLogService.Builder builder = StoreLogService.withRotation((long)internalLogRotationThreshold, (long)internalLogRotationDelay, (int)internalLogMaxArchives, (JobScheduler)this.jobScheduler);
        if (userLogProvider != null) {
            builder.withUserLogProvider(userLogProvider);
        }
        builder.withRotationListener(logProvider -> this.diagnosticsManager.dumpAll(logProvider.getLog(DiagnosticsManager.class)));
        for (String debugContext : (List)this.config.get(GraphDatabaseSettings.store_internal_debug_contexts)) {
            builder.withLevel(debugContext, Level.DEBUG);
        }
        builder.withDefaultLevel((Level)this.config.get(GraphDatabaseSettings.store_internal_log_level)).withTimeZone(((LogTimeZone)this.config.get(GraphDatabaseSettings.db_timezone)).getZoneId());
        File logFile = (File)this.config.get(GraphDatabaseSettings.store_internal_log_path);
        if (!logFile.getParentFile().exists()) {
            logFile.getParentFile().mkdirs();
        }
        try {
            logService = builder.withInternalLog(logFile).build(this.fileSystem);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return (LogService)this.life.add((Lifecycle)logService);
    }

    protected JobScheduler createJobScheduler() {
        return JobSchedulerFactory.createInitialisedScheduler();
    }

    protected PageCache createPageCache(FileSystemAbstraction fileSystem, Config config, LogService logging, Tracers tracers, VersionContextSupplier versionContextSupplier, JobScheduler jobScheduler) {
        Log pageCacheLog = logging.getInternalLog(PageCache.class);
        ConfiguringPageCacheFactory pageCacheFactory = new ConfiguringPageCacheFactory(fileSystem, config, tracers.pageCacheTracer, tracers.pageCursorTracerSupplier, pageCacheLog, versionContextSupplier, jobScheduler);
        PageCache pageCache = pageCacheFactory.getOrCreatePageCache();
        if (((Boolean)config.get(GraphDatabaseSettings.dump_configuration)).booleanValue()) {
            pageCacheFactory.dumpConfiguration();
        }
        return pageCache;
    }

    private static CollectionsFactorySupplier createCollectionsFactorySupplier(Config config, LifeSupport life) {
        GraphDatabaseSettings.TransactionStateMemoryAllocation allocation = (GraphDatabaseSettings.TransactionStateMemoryAllocation)config.get(GraphDatabaseSettings.tx_state_memory_allocation);
        switch (allocation) {
            case ON_HEAP: {
                return CollectionsFactorySupplier.ON_HEAP;
            }
            case OFF_HEAP: {
                CachingOffHeapBlockAllocator allocator = new CachingOffHeapBlockAllocator(((Long)config.get(GraphDatabaseSettings.tx_state_off_heap_max_cacheable_block_size)).longValue(), ((Integer)config.get(GraphDatabaseSettings.tx_state_off_heap_block_cache_size)).intValue());
                long maxMemory = (Long)config.get(GraphDatabaseSettings.tx_state_max_off_heap_memory);
                Object sharedBlockAllocator = maxMemory > 0L ? new CapacityLimitingBlockAllocatorDecorator((OffHeapBlockAllocator)allocator, maxMemory) : allocator;
                life.add(LifecycleAdapter.onShutdown(() -> ((OffHeapBlockAllocator)sharedBlockAllocator).release()));
                return () -> PlatformModule.lambda$createCollectionsFactorySupplier$1((OffHeapBlockAllocator)sharedBlockAllocator);
            }
        }
        throw new IllegalArgumentException("Unknown transaction state memory allocation value: " + allocation);
    }

    private static /* synthetic */ CollectionsFactory lambda$createCollectionsFactorySupplier$1(OffHeapBlockAllocator sharedBlockAllocator) {
        return new OffHeapCollectionsFactory(sharedBlockAllocator);
    }
}

