/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory.module;

import java.net.URL;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.facade.spi.ProcedureGDBFacadeSPI;
import org.neo4j.graphdb.factory.module.DataSourceModule;
import org.neo4j.graphdb.factory.module.PlatformModule;
import org.neo4j.graphdb.security.URLAccessValidationError;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.proc.Context;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.core.TokenHolders;
import org.neo4j.kernel.impl.coreapi.CoreAPIAvailabilityGuard;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;

public class ProcedureGDSFactory
implements ThrowingFunction<Context, GraphDatabaseService, ProcedureException> {
    private final PlatformModule platform;
    private final DataSourceModule dataSource;
    private final CoreAPIAvailabilityGuard availability;
    private final ThrowingFunction<URL, URL, URLAccessValidationError> urlValidator;
    private final TokenHolders tokenHolders;
    private final ThreadToStatementContextBridge bridge;

    ProcedureGDSFactory(PlatformModule platform, DataSourceModule dataSource, CoreAPIAvailabilityGuard coreAPIAvailabilityGuard, TokenHolders tokenHolders, ThreadToStatementContextBridge bridge) {
        this.platform = platform;
        this.dataSource = dataSource;
        this.availability = coreAPIAvailabilityGuard;
        this.urlValidator = url -> platform.urlAccessRule.validate((Configuration)platform.config, url);
        this.tokenHolders = tokenHolders;
        this.bridge = bridge;
    }

    public GraphDatabaseService apply(Context context) throws ProcedureException {
        KernelTransaction tx = (KernelTransaction)context.getOrElse(Context.KERNEL_TRANSACTION, null);
        SecurityContext securityContext = tx != null ? tx.securityContext() : (SecurityContext)context.get(Context.SECURITY_CONTEXT);
        GraphDatabaseFacade facade = new GraphDatabaseFacade();
        ProcedureGDBFacadeSPI procedureGDBFacadeSPI = new ProcedureGDBFacadeSPI(this.dataSource, this.dataSource.neoStoreDataSource.getDependencyResolver(), this.availability, this.urlValidator, securityContext, this.bridge);
        facade.init((GraphDatabaseFacade.SPI)procedureGDBFacadeSPI, this.bridge, this.platform.config, this.tokenHolders);
        return facade;
    }
}

