/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory.module.edition;

import java.io.File;
import java.time.Clock;
import java.util.function.Function;
import java.util.function.Predicate;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.dmbs.database.DefaultDatabaseManager;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.factory.module.PlatformModule;
import org.neo4j.graphdb.factory.module.edition.SecurityModuleDependenciesDependencies;
import org.neo4j.graphdb.factory.module.edition.context.DatabaseEditionContext;
import org.neo4j.helpers.Service;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.watcher.FileWatchEventListener;
import org.neo4j.io.fs.watcher.FileWatcher;
import org.neo4j.io.fs.watcher.RestartableFileSystemWatcher;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.api.net.NetworkConnectionTracker;
import org.neo4j.kernel.api.security.SecurityModule;
import org.neo4j.kernel.api.security.provider.SecurityProvider;
import org.neo4j.kernel.availability.AvailabilityGuard;
import org.neo4j.kernel.availability.DatabaseAvailabilityGuard;
import org.neo4j.kernel.builtinprocs.BuiltInDbmsProcedures;
import org.neo4j.kernel.builtinprocs.BuiltInFunctions;
import org.neo4j.kernel.builtinprocs.BuiltInProcedures;
import org.neo4j.kernel.builtinprocs.TokenProcedures;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.factory.AccessCapability;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.proc.ProcedureConfig;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.proc.temporal.TemporalFunction;
import org.neo4j.kernel.impl.transaction.TransactionHeaderInformationFactory;
import org.neo4j.kernel.impl.transaction.stats.DatabaseTransactionStats;
import org.neo4j.kernel.impl.transaction.stats.TransactionCounters;
import org.neo4j.kernel.impl.util.watcher.DefaultFileDeletionEventListener;
import org.neo4j.kernel.impl.util.watcher.DefaultFileSystemWatcherService;
import org.neo4j.kernel.impl.util.watcher.FileSystemWatcherService;
import org.neo4j.logging.Log;
import org.neo4j.logging.Logger;
import org.neo4j.logging.internal.LogService;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.udc.UsageData;
import org.neo4j.udc.UsageDataKeys;

public abstract class AbstractEditionModule {
    private final DatabaseTransactionStats databaseStatistics = new DatabaseTransactionStats();
    protected NetworkConnectionTracker connectionTracker;
    protected ThreadToStatementContextBridge threadToTransactionBridge;
    protected long transactionStartTimeout;
    protected TransactionHeaderInformationFactory headerInformationFactory;
    protected SchemaWriteGuard schemaWriteGuard;
    protected ConstraintSemantics constraintSemantics;
    protected AccessCapability accessCapability;
    protected IOLimiter ioLimiter;
    protected Function<File, FileSystemWatcherService> watcherServiceFactory;
    protected AvailabilityGuard globalAvailabilityGuard;
    protected SecurityProvider securityProvider;

    public abstract DatabaseEditionContext createDatabaseContext(String var1);

    protected FileSystemWatcherService createFileSystemWatcherService(FileSystemAbstraction fileSystem, File databaseDirectory, LogService logging, JobScheduler jobScheduler, Config config, Predicate<String> fileNameFilter) {
        if (!((Boolean)config.get(GraphDatabaseSettings.filewatcher_enabled)).booleanValue()) {
            Log log = logging.getInternalLog(this.getClass());
            log.info("File watcher disabled by configuration.");
            return FileSystemWatcherService.EMPTY_WATCHER;
        }
        try {
            RestartableFileSystemWatcher watcher = new RestartableFileSystemWatcher(fileSystem.fileWatcher());
            watcher.addFileWatchEventListener((FileWatchEventListener)new DefaultFileDeletionEventListener(logging, fileNameFilter));
            watcher.watch(databaseDirectory);
            watcher.watch(databaseDirectory.getParentFile());
            return new DefaultFileSystemWatcherService(jobScheduler, (FileWatcher)watcher);
        }
        catch (Exception e) {
            Log log = logging.getInternalLog(this.getClass());
            log.warn("Can not create file watcher for current file system. File monitoring capabilities for store files will be disabled.", (Throwable)e);
            return FileSystemWatcherService.EMPTY_WATCHER;
        }
    }

    public void registerProcedures(Procedures procedures, ProcedureConfig procedureConfig) throws KernelException {
        procedures.registerProcedure(BuiltInProcedures.class);
        procedures.registerProcedure(TokenProcedures.class);
        procedures.registerProcedure(BuiltInDbmsProcedures.class);
        procedures.registerBuiltInFunctions(BuiltInFunctions.class);
        TemporalFunction.registerTemporalFunctions((Procedures)procedures, (ProcedureConfig)procedureConfig);
        this.registerEditionSpecificProcedures(procedures);
    }

    protected abstract void registerEditionSpecificProcedures(Procedures var1) throws KernelException;

    protected void publishEditionInfo(UsageData sysInfo, DatabaseInfo databaseInfo, Config config) {
        sysInfo.set(UsageDataKeys.edition, (Object)databaseInfo.edition);
        sysInfo.set(UsageDataKeys.operationalMode, (Object)databaseInfo.operationalMode);
        config.augment(GraphDatabaseSettings.editionName, databaseInfo.edition.toString());
    }

    public DatabaseManager createDatabaseManager(GraphDatabaseFacade graphDatabaseFacade, PlatformModule platform, AbstractEditionModule edition, Procedures procedures, Logger msgLog) {
        return new DefaultDatabaseManager(platform, edition, procedures, msgLog, graphDatabaseFacade);
    }

    public abstract void createSecurityModule(PlatformModule var1, Procedures var2);

    protected static SecurityModule setupSecurityModule(PlatformModule platformModule, AbstractEditionModule editionModule, Log log, Procedures procedures, String key) {
        SecurityModuleDependenciesDependencies securityModuleDependencies = new SecurityModuleDependenciesDependencies(platformModule, editionModule, procedures);
        Iterable candidates = Service.load(SecurityModule.class);
        for (SecurityModule candidate : candidates) {
            if (!candidate.matches(key)) continue;
            try {
                candidate.setup((SecurityModule.Dependencies)securityModuleDependencies);
                return candidate;
            }
            catch (Exception e) {
                String errorMessage = "Failed to load security module.";
                String innerErrorMessage = e.getMessage();
                if (innerErrorMessage != null) {
                    log.error(errorMessage + " Caused by: " + innerErrorMessage, (Throwable)e);
                } else {
                    log.error(errorMessage, (Throwable)e);
                }
                throw new RuntimeException(errorMessage, e);
            }
        }
        String errorMessage = "Failed to load security module with key '" + key + "'.";
        log.error(errorMessage);
        throw new IllegalArgumentException(errorMessage);
    }

    protected NetworkConnectionTracker createConnectionTracker() {
        return NetworkConnectionTracker.NO_OP;
    }

    public DatabaseTransactionStats createTransactionMonitor() {
        return this.databaseStatistics;
    }

    public TransactionCounters globalTransactionCounter() {
        return this.databaseStatistics;
    }

    public AvailabilityGuard getGlobalAvailabilityGuard(Clock clock, LogService logService, Config config) {
        if (this.globalAvailabilityGuard == null) {
            this.globalAvailabilityGuard = new DatabaseAvailabilityGuard((String)config.get(GraphDatabaseSettings.active_database), clock, logService.getInternalLog(DatabaseAvailabilityGuard.class));
        }
        return this.globalAvailabilityGuard;
    }

    public DatabaseAvailabilityGuard createDatabaseAvailabilityGuard(String databaseName, Clock clock, LogService logService, Config config) {
        return (DatabaseAvailabilityGuard)this.getGlobalAvailabilityGuard(clock, logService, config);
    }

    public void createDatabases(DatabaseManager databaseManager, Config config) {
        databaseManager.createDatabase((String)config.get(GraphDatabaseSettings.active_database));
    }

    public long getTransactionStartTimeout() {
        return this.transactionStartTimeout;
    }

    public SchemaWriteGuard getSchemaWriteGuard() {
        return this.schemaWriteGuard;
    }

    public TransactionHeaderInformationFactory getHeaderInformationFactory() {
        return this.headerInformationFactory;
    }

    public ConstraintSemantics getConstraintSemantics() {
        return this.constraintSemantics;
    }

    public IOLimiter getIoLimiter() {
        return this.ioLimiter;
    }

    public AccessCapability getAccessCapability() {
        return this.accessCapability;
    }

    public Function<File, FileSystemWatcherService> getWatcherServiceFactory() {
        return this.watcherServiceFactory;
    }

    public ThreadToStatementContextBridge getThreadToTransactionBridge() {
        return this.threadToTransactionBridge;
    }

    public NetworkConnectionTracker getConnectionTracker() {
        return this.connectionTracker;
    }

    public SecurityProvider getSecurityProvider() {
        return this.securityProvider;
    }

    public void setSecurityProvider(SecurityProvider securityProvider) {
        this.securityProvider = securityProvider;
    }
}

