/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory.module.edition.context;

import java.io.File;
import java.time.Clock;
import java.util.function.Function;
import org.neo4j.graphdb.factory.module.edition.AbstractEditionModule;
import org.neo4j.graphdb.factory.module.edition.DefaultEditionModule;
import org.neo4j.graphdb.factory.module.edition.context.DatabaseEditionContext;
import org.neo4j.graphdb.factory.module.id.DatabaseIdContext;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.availability.DatabaseAvailabilityGuard;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.CommitProcessFactory;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.core.TokenHolders;
import org.neo4j.kernel.impl.factory.AccessCapability;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.StatementLocksFactory;
import org.neo4j.kernel.impl.transaction.TransactionHeaderInformationFactory;
import org.neo4j.kernel.impl.transaction.stats.DatabaseTransactionStats;
import org.neo4j.kernel.impl.util.watcher.FileSystemWatcherService;
import org.neo4j.logging.internal.LogService;
import org.neo4j.time.SystemNanoClock;

public class DefaultEditionModuleDatabaseContext
implements DatabaseEditionContext {
    private final Function<File, FileSystemWatcherService> watcherServiceFactory;
    private final String databaseName;
    private final AccessCapability accessCapability;
    private final IOLimiter ioLimiter;
    private final ConstraintSemantics constraintSemantics;
    private final CommitProcessFactory commitProcessFactory;
    private final TransactionHeaderInformationFactory headerInformationFactory;
    private final SchemaWriteGuard schemaWriteGuard;
    private final long transactionStartTimeout;
    private final TokenHolders tokenHolders;
    private final Locks locks;
    private final DatabaseTransactionStats transactionMonitor;
    private final AbstractEditionModule editionModule;
    private final DatabaseIdContext idContext;
    private final StatementLocksFactory statementLocksFactory;

    public DefaultEditionModuleDatabaseContext(DefaultEditionModule editionModule, String databaseName) {
        this.databaseName = databaseName;
        this.transactionStartTimeout = editionModule.getTransactionStartTimeout();
        this.schemaWriteGuard = editionModule.getSchemaWriteGuard();
        this.headerInformationFactory = editionModule.getHeaderInformationFactory();
        this.commitProcessFactory = editionModule.getCommitProcessFactory();
        this.constraintSemantics = editionModule.getConstraintSemantics();
        this.ioLimiter = editionModule.getIoLimiter();
        this.accessCapability = editionModule.getAccessCapability();
        this.watcherServiceFactory = editionModule.getWatcherServiceFactory();
        this.idContext = editionModule.getIdContextFactory().createIdContext(databaseName);
        this.tokenHolders = editionModule.getTokenHoldersProvider().apply(databaseName);
        this.locks = editionModule.getLocksSupplier().get();
        this.statementLocksFactory = editionModule.getStatementLocksFactoryProvider().apply(this.locks);
        this.transactionMonitor = editionModule.createTransactionMonitor();
        this.editionModule = editionModule;
    }

    @Override
    public DatabaseIdContext getIdContext() {
        return this.idContext;
    }

    @Override
    public TokenHolders createTokenHolders() {
        return this.tokenHolders;
    }

    @Override
    public Function<File, FileSystemWatcherService> getWatcherServiceFactory() {
        return this.watcherServiceFactory;
    }

    @Override
    public AccessCapability getAccessCapability() {
        return this.accessCapability;
    }

    @Override
    public IOLimiter getIoLimiter() {
        return this.ioLimiter;
    }

    @Override
    public ConstraintSemantics getConstraintSemantics() {
        return this.constraintSemantics;
    }

    @Override
    public CommitProcessFactory getCommitProcessFactory() {
        return this.commitProcessFactory;
    }

    @Override
    public TransactionHeaderInformationFactory getHeaderInformationFactory() {
        return this.headerInformationFactory;
    }

    @Override
    public SchemaWriteGuard getSchemaWriteGuard() {
        return this.schemaWriteGuard;
    }

    @Override
    public long getTransactionStartTimeout() {
        return this.transactionStartTimeout;
    }

    @Override
    public Locks createLocks() {
        return this.locks;
    }

    @Override
    public StatementLocksFactory createStatementLocksFactory() {
        return this.statementLocksFactory;
    }

    @Override
    public DatabaseTransactionStats createTransactionMonitor() {
        return this.transactionMonitor;
    }

    @Override
    public DatabaseAvailabilityGuard createDatabaseAvailabilityGuard(SystemNanoClock clock, LogService logService, Config config) {
        return this.editionModule.createDatabaseAvailabilityGuard(this.databaseName, (Clock)clock, logService, config);
    }
}

