/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory.module.id;

import java.util.Objects;
import java.util.function.Function;
import org.neo4j.graphdb.factory.module.id.IdContextFactory;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdReuseEligibility;
import org.neo4j.kernel.impl.store.id.configuration.CommunityIdTypeConfigurationProvider;
import org.neo4j.kernel.impl.store.id.configuration.IdTypeConfigurationProvider;
import org.neo4j.scheduler.JobScheduler;

public class IdContextFactoryBuilder {
    private IdReuseEligibility idReuseEligibility = IdReuseEligibility.ALWAYS;
    private FileSystemAbstraction fileSystemAbstraction;
    private JobScheduler jobScheduler;
    private Function<String, IdGeneratorFactory> idGeneratorFactoryProvider;
    private IdTypeConfigurationProvider idTypeConfigurationProvider;
    private Function<IdGeneratorFactory, IdGeneratorFactory> factoryWrapper;

    private IdContextFactoryBuilder() {
    }

    public static IdContextFactoryBuilder of(IdTypeConfigurationProvider configurationProvider, JobScheduler jobScheduler) {
        IdContextFactoryBuilder builder = new IdContextFactoryBuilder();
        builder.idTypeConfigurationProvider = configurationProvider;
        builder.jobScheduler = jobScheduler;
        return builder;
    }

    public static IdContextFactoryBuilder of(FileSystemAbstraction fileSystemAbstraction, JobScheduler jobScheduler) {
        IdContextFactoryBuilder builder = new IdContextFactoryBuilder();
        builder.fileSystemAbstraction = fileSystemAbstraction;
        builder.jobScheduler = jobScheduler;
        return builder;
    }

    public IdContextFactoryBuilder withFileSystem(FileSystemAbstraction fileSystem) {
        this.fileSystemAbstraction = fileSystem;
        return this;
    }

    public IdContextFactoryBuilder withIdReuseEligibility(IdReuseEligibility eligibleForIdReuse) {
        this.idReuseEligibility = eligibleForIdReuse;
        return this;
    }

    public IdContextFactoryBuilder withIdGenerationFactoryProvider(Function<String, IdGeneratorFactory> idGeneratorFactoryProvider) {
        this.idGeneratorFactoryProvider = idGeneratorFactoryProvider;
        return this;
    }

    public IdContextFactoryBuilder withFactoryWrapper(Function<IdGeneratorFactory, IdGeneratorFactory> factoryWrapper) {
        this.factoryWrapper = factoryWrapper;
        return this;
    }

    public IdContextFactory build() {
        if (this.idGeneratorFactoryProvider == null) {
            Objects.requireNonNull(this.fileSystemAbstraction, "File system is required to build id generator factory.");
            this.idGeneratorFactoryProvider = databaseName -> new DefaultIdGeneratorFactory(this.fileSystemAbstraction, this.idTypeConfigurationProvider);
        }
        if (this.idTypeConfigurationProvider == null) {
            this.idTypeConfigurationProvider = new CommunityIdTypeConfigurationProvider();
        }
        if (this.factoryWrapper == null) {
            this.factoryWrapper = Function.identity();
        }
        return new IdContextFactory(this.jobScheduler, this.idGeneratorFactoryProvider, this.idTypeConfigurationProvider, this.idReuseEligibility, this.factoryWrapper);
    }
}

