/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.net.URI;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.util.Arrays;
import java.util.Iterator;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.server.rest.repr.ExtensionInjector;
import org.neo4j.server.rest.repr.ListSerializer;
import org.neo4j.server.rest.repr.ListWriter;
import org.neo4j.server.rest.repr.MappingSerializer;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationFormat;
import org.neo4j.server.rest.repr.RepresentationType;
import org.neo4j.server.rest.repr.ValueRepresentation;

public class ListRepresentation
extends Representation {
    protected final Iterable<? extends Representation> content;

    public ListRepresentation(String type, Iterable<? extends Representation> content) {
        super(type);
        this.content = content;
    }

    public ListRepresentation(RepresentationType type, Iterable<? extends Representation> content) {
        super(type);
        this.content = content;
    }

    @Override
    String serialize(RepresentationFormat format, URI baseUri, ExtensionInjector extensions) {
        ListWriter writer = format.serializeList(this.type);
        this.serialize(new ListSerializer(writer, baseUri, extensions));
        writer.done();
        return format.complete(writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void serialize(ListSerializer serializer) {
        Iterator<? extends Representation> contentIterator = this.content.iterator();
        try {
            while (contentIterator.hasNext()) {
                Representation repr = contentIterator.next();
                repr.addTo(serializer);
            }
        }
        finally {
            while (contentIterator.hasNext()) {
                contentIterator.next();
            }
        }
    }

    @Override
    void addTo(ListSerializer serializer) {
        serializer.addList(this);
    }

    @Override
    void putTo(MappingSerializer serializer, String key) {
        serializer.putList(key, this);
    }

    public static ListRepresentation strings(String ... values) {
        return ListRepresentation.string(Arrays.asList(values));
    }

    public static ListRepresentation string(Iterable<String> values) {
        return new ListRepresentation(RepresentationType.STRING, (Iterable<? extends Representation>)new IterableWrapper<Representation, String>(values){

            protected Representation underlyingObjectToObject(String value) {
                return ValueRepresentation.string(value);
            }
        });
    }

    public static ListRepresentation points(Point ... values) {
        return ListRepresentation.point(Arrays.asList(values));
    }

    public static ListRepresentation point(Iterable<Point> values) {
        return new ListRepresentation(RepresentationType.POINT, (Iterable<? extends Representation>)new IterableWrapper<Representation, Point>(values){

            protected Representation underlyingObjectToObject(Point value) {
                return ValueRepresentation.point(value);
            }
        });
    }

    public static ListRepresentation temporals(Temporal ... values) {
        return ListRepresentation.temporal(Arrays.asList(values));
    }

    public static ListRepresentation temporal(Iterable<Temporal> values) {
        return new ListRepresentation(RepresentationType.TEMPORAL, (Iterable<? extends Representation>)new IterableWrapper<Representation, Temporal>(values){

            protected Representation underlyingObjectToObject(Temporal value) {
                return ValueRepresentation.temporal(value);
            }
        });
    }

    public static ListRepresentation temporalAmounts(TemporalAmount ... values) {
        return ListRepresentation.temporalAmount(Arrays.asList(values));
    }

    public static ListRepresentation temporalAmount(Iterable<TemporalAmount> values) {
        return new ListRepresentation(RepresentationType.TEMPORAL_AMOUNT, (Iterable<? extends Representation>)new IterableWrapper<Representation, TemporalAmount>(values){

            protected Representation underlyingObjectToObject(TemporalAmount value) {
                return ValueRepresentation.temporalAmount(value);
            }
        });
    }

    public static ListRepresentation relationshipTypes(Iterable<RelationshipType> types) {
        return new ListRepresentation(RepresentationType.RELATIONSHIP_TYPE, (Iterable<? extends Representation>)new IterableWrapper<Representation, RelationshipType>(types){

            protected Representation underlyingObjectToObject(RelationshipType value) {
                return ValueRepresentation.relationshipType(value);
            }
        });
    }

    public static ListRepresentation numbers(final long ... values) {
        return new ListRepresentation(RepresentationType.LONG, () -> new PrefetchingIterator<ValueRepresentation>(){
            int pos;

            protected ValueRepresentation fetchNextOrNull() {
                if (this.pos >= values.length) {
                    return null;
                }
                return ValueRepresentation.number(values[this.pos++]);
            }
        });
    }

    public static ListRepresentation numbers(final double[] values) {
        return new ListRepresentation(RepresentationType.DOUBLE, () -> new PrefetchingIterator<ValueRepresentation>(){
            int pos;

            protected ValueRepresentation fetchNextOrNull() {
                if (this.pos >= values.length) {
                    return null;
                }
                return ValueRepresentation.number(values[this.pos++]);
            }
        });
    }
}

