/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers.collection;

import java.util.Iterator;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.PrefetchingResourceIterator;

public abstract class NestingResourceIterator<T, U>
extends PrefetchingResourceIterator<T> {
    private final Iterator<U> source;
    private ResourceIterator<T> currentNestedIterator;
    private U currentSurfaceItem;

    public NestingResourceIterator(Iterator<U> source) {
        this.source = source;
    }

    protected abstract ResourceIterator<T> createNestedIterator(U var1);

    @Override
    protected T fetchNextOrNull() {
        if (this.currentNestedIterator == null || !this.currentNestedIterator.hasNext()) {
            while (this.source.hasNext()) {
                this.currentSurfaceItem = this.source.next();
                this.close();
                this.currentNestedIterator = this.createNestedIterator(this.currentSurfaceItem);
                if (!this.currentNestedIterator.hasNext()) continue;
            }
        }
        return (T)(this.currentNestedIterator != null && this.currentNestedIterator.hasNext() ? this.currentNestedIterator.next() : null);
    }

    public void close() {
        if (this.currentNestedIterator != null) {
            this.currentNestedIterator.close();
        }
    }
}

