/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.export.providers;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.commons.compress.utils.IOUtils;
import org.neo4j.cli.CommandFailedException;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.export.UploadCommand;
import org.neo4j.export.providers.SignedUpload;
import org.neo4j.export.util.IOCommon;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;

public class SignedUploadAWS
implements SignedUpload {
    private static final int RETRIES_COUNT = 5;
    private static final long DEFAULT_MAXIMUM_RETRY_BACKOFF_MILLIS = TimeUnit.SECONDS.toMillis(64L);
    private final String[] signedLinks;
    private String uploadID;
    private final String boltURI;
    private final int totalParts;
    private final IOCommon.Sleeper sleeper;
    private final ExecutionContext ctx;

    public SignedUploadAWS(String[] signedLinks, String uploadID, int totalParts, ExecutionContext ctx, String boltURI) {
        this.signedLinks = signedLinks;
        this.uploadID = uploadID;
        this.totalParts = totalParts;
        this.ctx = ctx;
        this.boltURI = boltURI;
        this.sleeper = Thread::sleep;
    }

    public SignedUploadAWS(String[] signedLinks, String uploadID, int totalParts, ExecutionContext ctx, String boltURI, IOCommon.Sleeper sleeper) {
        this.signedLinks = signedLinks;
        this.uploadID = uploadID;
        this.totalParts = totalParts;
        this.ctx = ctx;
        this.boltURI = boltURI;
        this.sleeper = sleeper;
    }

    @Override
    public void copy(boolean verbose, UploadCommand.Source src) {
        try {
            this.upload(src);
        }
        catch (IOException e) {
            throw new CommandFailedException(e.getMessage(), (Throwable)e);
        }
    }

    public void upload(UploadCommand.Source src) throws IOException {
        int uploadPosition = this.getUploadPosition();
        long fileSize = IOCommon.getFileSize(src, this.ctx);
        ProgressListener progressListener = ProgressMonitorFactory.textual((OutputStream)this.ctx.out()).singlePart("Uploading to AWS (This may take a some time depending on file size and connection speed)", (long)this.signedLinks.length);
        long chunkSize = this.getChunkSize(fileSize);
        long filePosition = chunkSize * (long)uploadPosition;
        long totalBytesCopied = this.copyToUrls(src, chunkSize, filePosition, progressListener);
        progressListener.close();
        this.ctx.out().println("Total bytes copied: " + totalBytesCopied);
    }

    private long copyToUrls(UploadCommand.Source src, long chunkSize, long filePosition, ProgressListener progressListener) throws IOException {
        Path source = src.path();
        BufferedInputStream sourceStream = new BufferedInputStream(Files.newInputStream(source, new OpenOption[0]));
        IOCommon.safeSkip(sourceStream, filePosition);
        long totalBytesCopied = 0L;
        for (int i = 0; i < this.signedLinks.length; ++i) {
            totalBytesCopied += this.copyToUrl(i, this.signedLinks[i], sourceStream, chunkSize, source, progressListener);
        }
        return totalBytesCopied;
    }

    /*
     * Loose catch block
     */
    private long copyToUrl(int i, String link, InputStream sourceStream, long chunkSize, Path source, ProgressListener progressListener) throws IOException {
        int retries = 0;
        while (retries < 5) {
            long l;
            Closeable ignored;
            block9: {
                URL url = IOCommon.safeUrl(link);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                ignored = connection::disconnect;
                connection.setRequestMethod("PUT");
                connection.setDoOutput(true);
                sourceStream.mark((int)chunkSize);
                long bytesCopied = this.copyToMultiPartURL(i, sourceStream, chunkSize, connection);
                this.checkResponseOk(connection, source);
                progressListener.add(1L);
                l = bytesCopied;
                if (ignored == null) break block9;
                ignored.close();
            }
            return l;
            {
                catch (RetryableHttpException e) {
                    try {
                        this.ctx.err().println(String.format("%s Failed to upload part %d to multipart url. Retrying in case of connection issue", e.getMessage(), i));
                        sourceStream.reset();
                        this.waitBeforeNextAttempt(retries);
                        ++retries;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (ignored == null) continue;
                        ignored.close();
                    }
                }
            }
        }
        throw new CommandFailedException("Failed to upload part to multipart url after 5 retries. Please check your Internet connection and try again.");
    }

    private void waitBeforeNextAttempt(int attemptNumber) {
        try {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            long backoffFromRetryCount = TimeUnit.SECONDS.toMillis(1L << attemptNumber) + (long)random.nextInt(1000);
            this.sleeper.sleep(Long.min(backoffFromRetryCount, DEFAULT_MAXIMUM_RETRY_BACKOFF_MILLIS));
        }
        catch (InterruptedException e) {
            this.ctx.err().println("Interrupted waiting to retry connection to upload URL");
            throw new CommandFailedException(e.getMessage());
        }
    }

    private void checkResponseOk(HttpURLConnection connection, Path dumpDir) throws RetryableHttpException {
        int responseCode = 0;
        try {
            responseCode = connection.getResponseCode();
            switch (responseCode) {
                case 200: {
                    return;
                }
                case 500: 
                case 502: 
                case 503: 
                case 504: {
                    throw new RetryableHttpException(new IOException("Received error response from server"));
                }
            }
            this.ctx.err().println(String.format("Received HTTP error: %d uploading to AWS", responseCode));
            throw this.resumePossibleErrorResponse(dumpDir);
        }
        catch (IOException e) {
            this.ctx.out().println("Response code: " + responseCode);
            throw new RetryableHttpException(e);
        }
    }

    private CommandFailedException resumePossibleErrorResponse(Path dump) throws IOException {
        return new CommandFailedException("We encountered a problem while communicating to the Neo4j Aura system. \nYou can re-try using the existing dump by running this command: \n" + String.format("neo4j-admin push-to-cloud --%s=%s --%s=%s", "dump", dump.toAbsolutePath(), "bolt-uri", this.boltURI));
    }

    private long copyToMultiPartURL(int currentPosition, InputStream sourceStream, long chunkSize, HttpURLConnection connection) throws RetryableHttpException {
        try {
            if (currentPosition == this.signedLinks.length - 1) {
                return IOUtils.copy((InputStream)sourceStream, (OutputStream)connection.getOutputStream());
            }
            return IOUtils.copyRange((InputStream)sourceStream, (long)chunkSize, (OutputStream)connection.getOutputStream());
        }
        catch (IOException e) {
            this.ctx.err().println(e.getMessage());
            throw new RetryableHttpException(e);
        }
    }

    public long getChunkSize(long fileSize) {
        if (this.totalParts <= 1) {
            return fileSize;
        }
        return (long)Math.ceil((double)fileSize / (double)this.totalParts);
    }

    private int getUploadPosition() {
        return this.totalParts - this.signedLinks.length;
    }

    static class RetryableHttpException
    extends RuntimeException {
        RetryableHttpException(IOException e) {
            super(e);
        }
    }
}

