/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.router.impl.query.parsing;

import java.util.Optional;
import org.neo4j.cypher.internal.PreParsedQuery;
import org.neo4j.cypher.internal.PreParser;
import org.neo4j.cypher.internal.ast.AdministrationCommand;
import org.neo4j.cypher.internal.ast.CatalogName;
import org.neo4j.cypher.internal.ast.Statement;
import org.neo4j.cypher.internal.compiler.CypherParsing;
import org.neo4j.cypher.internal.frontend.phases.BaseState;
import org.neo4j.cypher.internal.frontend.phases.CompilationPhaseTracer;
import org.neo4j.cypher.internal.tracing.CompilationTracer;
import org.neo4j.cypher.internal.util.CancellationChecker;
import org.neo4j.cypher.internal.util.InternalNotificationLogger;
import org.neo4j.cypher.internal.util.RecordingNotificationLogger;
import org.neo4j.fabric.eval.StaticUseEvaluation;
import org.neo4j.router.query.Query;
import org.neo4j.router.query.QueryTargetParser;
import scala.Option;
import scala.jdk.javaapi.OptionConverters;

public class StandardQueryTargetParser
implements QueryTargetParser {
    public static final CatalogName SYSTEM_DATABASE_CATALOG_NAME = CatalogName.of((String)"system");
    private final QueryTargetParser.Cache cache;
    private final PreParser preParser;
    private final CypherParsing parsing;
    private final CompilationTracer tracer;
    private final CancellationChecker cancellationChecker;
    private final StaticUseEvaluation staticUseEvaluation = new StaticUseEvaluation();

    public StandardQueryTargetParser(QueryTargetParser.Cache cache, PreParser preParser, CypherParsing parsing, CompilationTracer tracer, CancellationChecker cancellationChecker) {
        this.cache = cache;
        this.preParser = preParser;
        this.parsing = parsing;
        this.tracer = tracer;
        this.cancellationChecker = cancellationChecker;
    }

    @Override
    public Optional<CatalogName> parseQueryTarget(Query query) {
        return this.cache.computeIfAbsent(query.text(), () -> this.doParseQueryTarget(query));
    }

    private Optional<CatalogName> doParseQueryTarget(Query query) {
        CompilationTracer.QueryCompilationEvent queryTracer = this.tracer.compileQuery(query.text());
        RecordingNotificationLogger notificationLogger = new RecordingNotificationLogger();
        PreParsedQuery preParsedQuery = this.preParser.preParse(query.text(), (InternalNotificationLogger)notificationLogger);
        BaseState parsedQuery = this.parse(query, queryTracer, preParsedQuery);
        return this.determineTarget(parsedQuery);
    }

    private BaseState parse(Query query, CompilationTracer.QueryCompilationEvent queryTracer, PreParsedQuery preParsedQuery) {
        return this.parsing.parseQuery(preParsedQuery.statement(), preParsedQuery.rawStatement(), (InternalNotificationLogger)new RecordingNotificationLogger(), preParsedQuery.options().queryOptions().planner().name(), Option.apply((Object)preParsedQuery.options().offset()), (CompilationPhaseTracer)queryTracer, query.parameters(), this.cancellationChecker);
    }

    private Optional<CatalogName> determineTarget(BaseState parsedQuery) {
        Statement statement = parsedQuery.statement();
        if (statement instanceof AdministrationCommand) {
            return Optional.of(SYSTEM_DATABASE_CATALOG_NAME);
        }
        Option catalogNameOption = this.staticUseEvaluation.evaluateStaticLeadingGraphSelection(statement);
        return OptionConverters.toJava((Option)catalogNameOption);
    }
}

