/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.layout.recordstorage;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.neo4j.io.layout.DatabaseFile;

public enum RecordDatabaseFile implements DatabaseFile
{
    NODE_STORE("neostore.nodestore.db"),
    NODE_LABEL_STORE("neostore.nodestore.db.labels"),
    PROPERTY_STORE("neostore.propertystore.db"),
    PROPERTY_ARRAY_STORE("neostore.propertystore.db.arrays"),
    PROPERTY_STRING_STORE("neostore.propertystore.db.strings"),
    PROPERTY_KEY_TOKEN_STORE("neostore.propertystore.db.index"),
    PROPERTY_KEY_TOKEN_NAMES_STORE("neostore.propertystore.db.index.keys"),
    RELATIONSHIP_STORE("neostore.relationshipstore.db"),
    RELATIONSHIP_GROUP_STORE("neostore.relationshipgroupstore.db"),
    RELATIONSHIP_TYPE_TOKEN_STORE("neostore.relationshiptypestore.db"),
    RELATIONSHIP_TYPE_TOKEN_NAMES_STORE("neostore.relationshiptypestore.db.names"),
    LABEL_TOKEN_STORE("neostore.labeltokenstore.db"),
    LABEL_TOKEN_NAMES_STORE("neostore.labeltokenstore.db.names"),
    SCHEMA_STORE("neostore.schemastore.db"),
    COUNTS_STORE("neostore.counts.db", false),
    RELATIONSHIP_GROUP_DEGREES_STORE("neostore.relationshipgroupstore.degrees.db", false),
    INDEX_STATISTICS_STORE("neostore.indexstats.db", false),
    METADATA_STORE("neostore", false),
    EXISTS_MARKER(METADATA_STORE);

    private final String name;
    private final boolean hasIdFile;
    private static final Set<RecordDatabaseFile> ALL_FILES;
    static final Set<RecordDatabaseFile> STORE_FILES;
    static final Set<RecordDatabaseFile> RECOVERABLE_STORE_FILES;

    private RecordDatabaseFile(String name) {
        this(name, true);
    }

    private RecordDatabaseFile(String name, boolean hasIdFile) {
        this.name = name;
        this.hasIdFile = hasIdFile;
    }

    private RecordDatabaseFile(RecordDatabaseFile file) {
        this.name = file.getName();
        this.hasIdFile = false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean hasIdFile() {
        return this.hasIdFile;
    }

    public static Optional<RecordDatabaseFile> fileOf(String name) {
        Objects.requireNonNull(name);
        return ALL_FILES.stream().filter(file -> file.getName().equals(name)).filter(Predicate.not(EXISTS_MARKER::equals)).findFirst();
    }

    static {
        ALL_FILES = Set.of(RecordDatabaseFile.values());
        STORE_FILES = ALL_FILES;
        RECOVERABLE_STORE_FILES = Set.of(COUNTS_STORE, RELATIONSHIP_GROUP_DEGREES_STORE, INDEX_STATISTICS_STORE);
    }
}

