/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.memory;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.neo4j.io.memory.ByteBuffers;
import org.neo4j.io.memory.ScopedBuffer;
import org.neo4j.memory.MemoryTracker;

public final class NativeScopedBuffer
implements ScopedBuffer {
    private final ByteBuffer buffer;
    private final MemoryTracker memoryTracker;
    private boolean closed;

    public NativeScopedBuffer(long capacity, ByteOrder byteOrder, MemoryTracker memoryTracker) {
        this(Math.toIntExact(capacity), byteOrder, memoryTracker);
    }

    public NativeScopedBuffer(int capacity, ByteOrder byteOrder, MemoryTracker memoryTracker) {
        this.buffer = ByteBuffers.allocateDirect(capacity, byteOrder, memoryTracker);
        this.memoryTracker = memoryTracker;
    }

    @Override
    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    public void close() {
        if (!this.closed) {
            ByteBuffers.releaseBuffer(this.buffer, this.memoryTracker);
            this.closed = true;
        }
    }
}

