/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.analysis.Analyzer;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.graphdb.schema.AnalyzerProvider;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexSettingsKeys;
import org.neo4j.service.Services;
import org.neo4j.values.storable.TextValue;

final class FulltextIndexAnalyzerLoader {
    public static final FulltextIndexAnalyzerLoader INSTANCE = new FulltextIndexAnalyzerLoader();
    private final ConcurrentHashMap<String, AnalyzerProvider> analyzerProviders = new ConcurrentHashMap();

    private FulltextIndexAnalyzerLoader() {
    }

    Analyzer createAnalyzer(IndexDescriptor descriptor, TokenNameLookup tokenNameLookup) {
        TextValue analyzerName = (TextValue)descriptor.getIndexConfig().get(FulltextIndexSettingsKeys.ANALYZER);
        if (analyzerName == null) {
            throw new RuntimeException("Index has no analyzer configured: " + descriptor.userDescription(tokenNameLookup));
        }
        return this.createAnalyzerFromString(analyzerName.stringValue());
    }

    Analyzer createAnalyzerFromString(String analyzerName) {
        Analyzer analyzer;
        AnalyzerProvider provider = this.analyzerProviders.get(analyzerName);
        if (provider == null && (provider = this.loadAll(analyzerName)) == null) {
            throw new RuntimeException(String.format("Could not create fulltext analyzer: %s. Could not find service provider %s[%s]", analyzerName, AnalyzerProvider.class.getName(), analyzerName));
        }
        try {
            analyzer = provider.createAnalyzer();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create fulltext analyzer: " + analyzerName, e);
        }
        Objects.requireNonNull(analyzer, "The '" + analyzerName + "' analyzer provider returned a null analyzer.");
        return analyzer;
    }

    private synchronized AnalyzerProvider loadAll(String analyzerName) {
        if (!this.analyzerProviders.containsKey(analyzerName)) {
            this.analyzerProviders.clear();
            for (AnalyzerProvider analyzerProvider : Services.loadAll(AnalyzerProvider.class)) {
                this.analyzerProviders.put(analyzerProvider.getName(), analyzerProvider);
            }
        }
        return this.analyzerProviders.get(analyzerName);
    }
}

