/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Supplier;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.impl.set.mutable.MutableSetFactoryImpl;
import org.neo4j.cli.AbstractAdminCommand;
import org.neo4j.cli.CommandFailedException;
import org.neo4j.cli.Converters;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.collection.Dependencies;
import org.neo4j.commandline.dbms.LockChecker;
import org.neo4j.common.DependencyResolver;
import org.neo4j.common.DependencySatisfier;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.helpers.DatabaseNamePattern;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.function.Suppliers;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.event.DatabaseEventListener;
import org.neo4j.graphdb.event.DatabaseEventListenerAdapter;
import org.neo4j.graphdb.facade.SystemDbUpgrader;
import org.neo4j.graphdb.factory.module.edition.migration.MigrationEditionModuleFactory;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.locker.FileLockException;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.context.EmptyVersionContextSupplier;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.extension.DatabaseExtensions;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.extension.ExtensionFailureStrategies;
import org.neo4j.kernel.extension.context.DatabaseExtensionContext;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.kernel.impl.pagecache.ConfigurableStandalonePageCacheFactory;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.impl.storemigration.StoreMigrator;
import org.neo4j.kernel.impl.storemigration.UnableToMigrateException;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadata;
import org.neo4j.kernel.impl.transaction.state.StaticIndexProviderMap;
import org.neo4j.kernel.impl.transaction.state.StaticIndexProviderMapFactory;
import org.neo4j.kernel.impl.util.Validators;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.recovery.LogTailExtractor;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.Level;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.SimpleLogService;
import org.neo4j.logging.log4j.Log4jLog;
import org.neo4j.logging.log4j.Log4jLogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.Monitors;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.service.Services;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.token.TokenHolders;
import picocli.CommandLine;

@CommandLine.Command(name="migrate", header={"Migrate a database"}, description={"Migrates a database from one format to another or between versions of the same format. It always migrates the database to the latest combination of major and minor version of the target format."})
public class MigrateStoreCommand
extends AbstractAdminCommand {
    @CommandLine.Parameters(arity="1", paramLabel="<database>", description={"Name of the database to migrate. Can contain * and ? for globbing. Note that * and ? have special meaning in some shells and might need to be escaped or used with quotes."}, converter={Converters.DatabaseNamePatternConverter.class})
    private DatabaseNamePattern database;
    @CommandLine.Option(names={"--to-format"}, paramLabel="standard|high_limit|aligned", description={"Name of the format to migrate the store to. If the format is specified, the target database is migrated to the latest known combination of MAJOR and MINOR versions of the specified format. If not specified, the tool migrates the target database to the latest known combination of MAJOR and MINOR versions of the current format."})
    private String formatToMigrateTo;
    @CommandLine.Option(names={"--pagecache"}, paramLabel="<size>", description={"The size of the page cache to use for the migration process. The general rule is that values up to the size of the database proportionally increase performance."})
    private String pagecacheMemory;
    @CommandLine.Option(names={"--force-btree-indexes-to-range"}, fallbackValue="true", description={"Special option for automatically turning all BTREE indexes/constraints into RANGE. Be aware that RANGE indexes are not always the optimal replacement of BTREEs and performance may be affected while the new indexes are populated. See the Neo4j v5 migration guide online for more information. The newly created indexes will be populated in the background on the first database start up following the migration and users should monitor the successful completion of that process."})
    private boolean forceBtreeToRange;
    @CommandLine.Option(names={"--force-system-database"}, hidden=true, fallbackValue="true", description={"A special option for forcing migration of Enterprise System database. This is only for internal use, because it works only if a well-defined subset of the DBMS features is used. The result is undefined in other cases."})
    protected boolean forceSystemDatabase;

    public MigrateStoreCommand(ExecutionContext ctx) {
        super(ctx);
    }

    protected Optional<String> commandConfigName() {
        return Optional.of("database-migrate");
    }

    protected void execute() {
        Config config = this.buildConfig();
        try (Log4jLogProvider logProvider = new Log4jLogProvider((OutputStream)this.ctx.out(), this.verbose ? Level.DEBUG : Level.INFO);){
            this.migrateStore(config, logProvider);
        }
    }

    protected void checkAllowedToMigrateSystemDb(StorageEngineFactory storageEngineFactory, FileSystemAbstraction fs, DatabaseLayout databaseLayout, PageCache pageCache, CursorContextFactory contextFactory) throws UnableToMigrateException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateStore(Config config, Log4jLogProvider logProvider) {
        DatabaseTracers databaseTracers = DatabaseTracers.EMPTY;
        PageCacheTracer pageCacheTracer = PageCacheTracer.NULL;
        EmptyMemoryTracker memoryTracker = EmptyMemoryTracker.INSTANCE;
        CursorContextFactory contextFactory = new CursorContextFactory(PageCacheTracer.NULL, EmptyVersionContextSupplier.EMPTY);
        ArrayList<FailedMigration> failedMigrations = new ArrayList<FailedMigration>();
        Log4jLog resultLog = logProvider.getLog(((Object)((Object)this)).getClass());
        try (DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();){
            Set<String> dbNames = this.getDbNames(config, (FileSystemAbstraction)fs);
            for (String dbName : dbNames) {
                resultLog.info("Starting migration for database '" + dbName + "'");
                LifeSupport life = new LifeSupport();
                String formatForDb = this.formatToMigrateTo;
                try {
                    JobScheduler jobScheduler = (JobScheduler)life.add((Lifecycle)JobSchedulerFactory.createInitialisedScheduler());
                    try {
                        PageCache pageCache = ConfigurableStandalonePageCacheFactory.createPageCache((FileSystemAbstraction)fs, (Config)config, (JobScheduler)jobScheduler, (PageCacheTracer)pageCacheTracer);
                        try {
                            DatabaseLayout databaseLayout = Neo4jLayout.of((Configuration)config).databaseLayout(dbName);
                            MigrateStoreCommand.checkDatabaseExistence(databaseLayout);
                            try {
                                Closeable ignored = LockChecker.checkDatabaseLock((DatabaseLayout)databaseLayout);
                                try {
                                    SimpleLogService logService = new SimpleLogService((InternalLogProvider)logProvider);
                                    StorageEngineFactory currentStorageEngineFactory = this.getCurrentStorageEngineFactory((FileSystemAbstraction)fs, databaseLayout);
                                    if ("system".equals(dbName)) {
                                        formatForDb = "aligned";
                                        this.checkAllowedToMigrateSystemDb(currentStorageEngineFactory, (FileSystemAbstraction)fs, databaseLayout, pageCache, contextFactory);
                                    }
                                    StaticIndexProviderMap indexProviderMap = MigrateStoreCommand.getIndexProviderMap((FileSystemAbstraction)fs, databaseLayout, config, (LogService)logService, pageCache, jobScheduler, life, currentStorageEngineFactory, pageCacheTracer, contextFactory);
                                    life.start();
                                    StoreMigrator storeMigrator = new StoreMigrator((FileSystemAbstraction)fs, config, (LogService)logService, pageCache, databaseTracers, jobScheduler, databaseLayout, currentStorageEngineFactory, (IndexProviderMap)indexProviderMap, contextFactory, (MemoryTracker)memoryTracker, (Supplier)Suppliers.lazySingleton(() -> this.lambda$migrateStore$0((FileSystemAbstraction)fs, pageCache, config, currentStorageEngineFactory, databaseLayout, memoryTracker)));
                                    storeMigrator.migrateIfNeeded(formatForDb, this.forceBtreeToRange);
                                }
                                finally {
                                    if (ignored == null) continue;
                                    ignored.close();
                                }
                            }
                            catch (FileLockException e) {
                                throw new CommandFailedException("The database is in use. Stop database '" + dbName + "' and try again.", (Throwable)e);
                            }
                        }
                        finally {
                            if (pageCache == null) continue;
                            pageCache.close();
                        }
                    }
                    finally {
                        if (jobScheduler == null) continue;
                        jobScheduler.close();
                    }
                }
                catch (Exception e) {
                    resultLog.error("Failed to migrate database '" + dbName + "': " + e.getMessage());
                    failedMigrations.add(new FailedMigration(dbName, e));
                }
                finally {
                    life.shutdown();
                }
            }
        }
        catch (IOException e) {
            throw new CommandFailedException(String.format("Failed to migrate database(s): %s: %s", e.getClass().getSimpleName(), e.getMessage()), (Throwable)e);
        }
        if (this.database.matches("system") && failedMigrations.stream().noneMatch(failedMigration -> "system".equals(failedMigration.dbName))) {
            try (Log4jLogProvider systemDbStartupLogProvider = new Log4jLogProvider((OutputStream)this.ctx.out(), this.verbose ? Level.DEBUG : Level.ERROR);){
                MigrateStoreCommand.upgradeSystemDb(config, logProvider, systemDbStartupLogProvider);
            }
            catch (Exception e) {
                resultLog.error("Failed to migrate database 'system': " + e.getMessage());
                failedMigrations.add(new FailedMigration("system", e));
            }
        }
        if (!failedMigrations.isEmpty()) {
            StringJoiner failedDbs = new StringJoiner("', '", "Migration failed for databases: '", "'");
            Exception exceptions = null;
            for (FailedMigration failedMigration2 : failedMigrations) {
                failedDbs.add(failedMigration2.dbName);
                exceptions = (Exception)Exceptions.chain(exceptions, (Throwable)failedMigration2.e);
            }
            resultLog.error(failedDbs.toString());
            throw new CommandFailedException(failedDbs.toString(), exceptions);
        }
        resultLog.info("Database migration completed successfully");
    }

    private Set<String> getDbNames(Config config, FileSystemAbstraction fs) {
        if (!this.database.containsPattern()) {
            return Set.of(this.database.getDatabaseName());
        }
        MutableSet dbNames = MutableSetFactoryImpl.INSTANCE.empty();
        Path databasesDir = Neo4jLayout.of((Configuration)config).databasesDirectory();
        try {
            for (Path path : fs.listFiles(databasesDir)) {
                String name;
                if (!fs.isDirectory(path) || !this.database.matches(name = path.getFileName().toString())) continue;
                dbNames.add(name);
            }
        }
        catch (IOException e) {
            throw new CommandFailedException(String.format("Failed to list databases: %s: %s", e.getClass().getSimpleName(), e.getMessage()), (Throwable)e);
        }
        if (dbNames.isEmpty()) {
            throw new CommandFailedException("Pattern '" + this.database.getDatabaseName() + "' did not match any database");
        }
        return dbNames;
    }

    private static void upgradeSystemDb(Config config, Log4jLogProvider logProvider, Log4jLogProvider systemDbStartupLogProvider) {
        try {
            MigrationEditionModuleFactory editionModuleFactory = MigrateStoreCommand.loadEditionModuleFactory();
            SystemDbUpgrader.upgrade(editionModuleFactory, config, (InternalLogProvider)logProvider, (InternalLogProvider)systemDbStartupLogProvider, (DatabaseEventListener)new DatabaseEventListenerAdapter());
        }
        catch (Exception e) {
            throw new CommandFailedException(e.getMessage(), (Throwable)e);
        }
    }

    private static MigrationEditionModuleFactory loadEditionModuleFactory() {
        Optional editionModuleFactory = Services.loadByPriority(MigrationEditionModuleFactory.class);
        return (MigrationEditionModuleFactory)editionModuleFactory.orElseThrow(() -> new IllegalStateException("Could not find any implementations of " + MigrationEditionModuleFactory.class));
    }

    private LogTailMetadata loadLogTail(FileSystemAbstraction fs, PageCache pageCache, Config config, StorageEngineFactory engineFactory, DatabaseTracers databaseTracers, DatabaseLayout layout, MemoryTracker memoryTracker) {
        try {
            return new LogTailExtractor(fs, pageCache, config, engineFactory, databaseTracers).getTailMetadata(layout, memoryTracker, () -> KernelVersion.getLatestVersion((Config)config));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static void checkDatabaseExistence(DatabaseLayout databaseLayout) {
        try {
            Validators.CONTAINS_EXISTING_DATABASE.validate((Object)databaseLayout.databaseDirectory());
        }
        catch (IllegalArgumentException e) {
            throw new CommandFailedException("Database '" + databaseLayout.getDatabaseName() + "' does not exist", (Throwable)e);
        }
    }

    private StorageEngineFactory getCurrentStorageEngineFactory(FileSystemAbstraction fs, DatabaseLayout databaseLayout) {
        return (StorageEngineFactory)StorageEngineFactory.selectStorageEngine((FileSystemAbstraction)fs, (DatabaseLayout)databaseLayout).orElseThrow(() -> new CommandFailedException("Current store format has not been recognised by any of the available storage engines"));
    }

    private Config buildConfig() {
        try {
            Config.Builder builder = this.createPrefilledConfigBuilder();
            if (this.pagecacheMemory != null) {
                builder.set(GraphDatabaseSettings.pagecache_memory, (Object)ByteUnit.parse((String)this.pagecacheMemory));
            }
            return builder.build();
        }
        catch (Exception e) {
            throw new CommandFailedException(e.getMessage(), (Throwable)e);
        }
    }

    private static StaticIndexProviderMap getIndexProviderMap(FileSystemAbstraction fs, DatabaseLayout databaseLayout, Config config, LogService logService, PageCache pageCache, JobScheduler jobScheduler, LifeSupport life, StorageEngineFactory storageEngineFactory, PageCacheTracer pageCacheTracer, CursorContextFactory contextFactory) {
        RecoveryCleanupWorkCollector recoveryCleanupWorkCollector = RecoveryCleanupWorkCollector.ignore();
        Monitors monitors = new Monitors();
        TokenHolders tokenHolders = storageEngineFactory.loadReadOnlyTokens(fs, databaseLayout, config, pageCache, pageCacheTracer, true, contextFactory);
        DatabaseExtensions extensions = (DatabaseExtensions)life.add((Lifecycle)MigrateStoreCommand.instantiateExtensions(fs, databaseLayout, config, logService, pageCache, jobScheduler, recoveryCleanupWorkCollector, monitors, tokenHolders, pageCacheTracer, DatabaseReadOnlyChecker.readOnly()));
        return (StaticIndexProviderMap)life.add((Lifecycle)StaticIndexProviderMapFactory.create((LifeSupport)life, (Config)config, (PageCache)pageCache, (FileSystemAbstraction)fs, (LogService)logService, (Monitors)monitors, (DatabaseReadOnlyChecker)DatabaseReadOnlyChecker.readOnly(), (TopologyGraphDbmsModel.HostedOnMode)TopologyGraphDbmsModel.HostedOnMode.SINGLE, (RecoveryCleanupWorkCollector)recoveryCleanupWorkCollector, (DatabaseLayout)databaseLayout, (TokenHolders)tokenHolders, (JobScheduler)jobScheduler, (CursorContextFactory)contextFactory, (PageCacheTracer)pageCacheTracer, (DependencyResolver)extensions));
    }

    private static DatabaseExtensions instantiateExtensions(FileSystemAbstraction fs, DatabaseLayout databaseLayout, Config config, LogService logService, PageCache pageCache, JobScheduler jobScheduler, RecoveryCleanupWorkCollector recoveryCollector, Monitors monitors, TokenHolders tokenHolders, PageCacheTracer pageCacheTracer, DatabaseReadOnlyChecker readOnlyChecker) {
        Dependencies deps = new Dependencies();
        deps.satisfyDependencies(new Object[]{fs, config, logService, pageCache, recoveryCollector, monitors, jobScheduler, tokenHolders, pageCacheTracer, databaseLayout, readOnlyChecker});
        Collection extensions = Services.loadAll(ExtensionFactory.class);
        DatabaseExtensionContext extensionContext = new DatabaseExtensionContext(databaseLayout, DbmsInfo.TOOL, (DependencySatisfier)deps);
        return new DatabaseExtensions(extensionContext, (Iterable)extensions, deps, ExtensionFailureStrategies.ignore());
    }

    private /* synthetic */ LogTailMetadata lambda$migrateStore$0(FileSystemAbstraction fs, PageCache pageCache, Config config, StorageEngineFactory currentStorageEngineFactory, DatabaseLayout databaseLayout, EmptyMemoryTracker memoryTracker) {
        return this.loadLogTail(fs, pageCache, config, currentStorageEngineFactory, DatabaseTracers.EMPTY, databaseLayout, (MemoryTracker)memoryTracker);
    }

    record FailedMigration(String dbName, Exception e) {
    }
}

