/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import java.util.Map;
import java.util.Optional;
import org.neo4j.configuration.DatabaseConfig;
import org.neo4j.cypher.internal.javacompat.CommunityCypherEngineProvider;
import org.neo4j.dbms.database.AbstractDatabaseContextFactory;
import org.neo4j.dbms.database.DefaultDatabaseContextFactoryComponents;
import org.neo4j.dbms.database.StandaloneDatabaseContext;
import org.neo4j.dbms.identity.ServerIdentity;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.factory.module.GlobalModule;
import org.neo4j.graphdb.factory.module.ModularDatabaseCreationContext;
import org.neo4j.graphdb.factory.module.id.IdContextFactory;
import org.neo4j.io.device.DeviceMapper;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.api.Kernel;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.database.DatabaseCreationContext;
import org.neo4j.kernel.database.DatabaseStartupController;
import org.neo4j.kernel.database.GlobalAvailabilityGuardController;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.api.CommitProcessFactory;
import org.neo4j.kernel.impl.api.ExternalIdReuseConditionProvider;
import org.neo4j.kernel.impl.api.LeaseService;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.constraints.StandardConstraintSemantics;
import org.neo4j.kernel.impl.factory.AccessCapabilityFactory;
import org.neo4j.kernel.impl.index.DatabaseIndexStats;
import org.neo4j.kernel.impl.pagecache.CommunityVersionStorageFactory;
import org.neo4j.kernel.impl.pagecache.IOControllerService;
import org.neo4j.kernel.impl.pagecache.VersionStorageFactory;
import org.neo4j.kernel.impl.query.QueryEngineProvider;
import org.neo4j.kernel.impl.transaction.stats.DatabaseTransactionStats;

public class DefaultDatabaseContextFactory
extends AbstractDatabaseContextFactory<StandaloneDatabaseContext, Optional<?>> {
    private final DatabaseTransactionStats.Factory transactionStatsFactory;
    private final DatabaseIndexStats.Factory indexStatsFactory;
    private final DeviceMapper deviceMapper;
    private final IOControllerService controllerService;
    private final CommitProcessFactory commitProcessFactory;
    private final DefaultDatabaseContextFactoryComponents components;
    private final ServerIdentity serverIdentity;

    public DefaultDatabaseContextFactory(GlobalModule globalModule, ServerIdentity serverIdentity, DatabaseTransactionStats.Factory transactionStatsFactory, DatabaseIndexStats.Factory indexStatsFactory, IdContextFactory idContextFactory, DeviceMapper deviceMapper, IOControllerService controllerService, CommitProcessFactory commitProcessFactory, DefaultDatabaseContextFactoryComponents components) {
        super(globalModule, idContextFactory);
        this.serverIdentity = serverIdentity;
        this.transactionStatsFactory = transactionStatsFactory;
        this.indexStatsFactory = indexStatsFactory;
        this.deviceMapper = deviceMapper;
        this.controllerService = controllerService;
        this.commitProcessFactory = commitProcessFactory;
        this.components = components;
    }

    @Override
    public StandaloneDatabaseContext create(NamedDatabaseId namedDatabaseId, Optional<?> ignored) {
        return new Creator(namedDatabaseId).context();
    }

    private class Creator {
        private final Database kernelDatabase;
        private final StandaloneDatabaseContext context;

        private Creator(NamedDatabaseId namedDatabaseId) {
            DatabaseConfig databaseConfig = new DatabaseConfig(Map.of(), DefaultDatabaseContextFactory.this.globalModule.getGlobalConfig());
            CursorContextFactory contextFactory = DefaultDatabaseContextFactory.this.createContextFactory(databaseConfig, namedDatabaseId);
            ModularDatabaseCreationContext creationContext = new ModularDatabaseCreationContext(TopologyGraphDbmsModel.HostedOnMode.SINGLE, DefaultDatabaseContextFactory.this.serverIdentity, namedDatabaseId, DefaultDatabaseContextFactory.this.globalModule, DefaultDatabaseContextFactory.this.globalModule.getGlobalDependencies(), contextFactory, DefaultDatabaseContextFactory.this.deviceMapper, (VersionStorageFactory)new CommunityVersionStorageFactory(), databaseConfig, DefaultDatabaseContextFactory.this.globalModule.getGlobalMonitors(), LeaseService.NO_LEASES, () -> DatabaseCreationContext.selectStorageEngine((FileSystemAbstraction)DefaultDatabaseContextFactory.this.globalModule.getFileSystem(), (Neo4jLayout)DefaultDatabaseContextFactory.this.globalModule.getNeo4jLayout(), (Configuration)databaseConfig, (NamedDatabaseId)namedDatabaseId), (ConstraintSemantics)new StandardConstraintSemantics(), (QueryEngineProvider)new CommunityCypherEngineProvider(), DefaultDatabaseContextFactory.this.transactionStatsFactory.create(), DefaultDatabaseContextFactory.this.indexStatsFactory.create(), ModularDatabaseCreationContext.defaultFileWatcherFilter(), AccessCapabilityFactory.configDependent(), ExternalIdReuseConditionProvider.NONE, DefaultDatabaseContextFactory.this.idContextFactory.createIdContext(namedDatabaseId, contextFactory, databaseConfig), DefaultDatabaseContextFactory.this.commitProcessFactory, AbstractDatabaseContextFactory.createTokenHolderProvider(this::kernel), (DatabaseStartupController)new GlobalAvailabilityGuardController(DefaultDatabaseContextFactory.this.globalModule.getGlobalAvailabilityGuard()), DefaultDatabaseContextFactory.this.components.readOnlyDatabases(), DefaultDatabaseContextFactory.this.controllerService);
            this.kernelDatabase = new Database((DatabaseCreationContext)creationContext);
            this.context = new StandaloneDatabaseContext(this.kernelDatabase);
        }

        private StandaloneDatabaseContext context() {
            return this.context;
        }

        private Kernel kernel() {
            return (Kernel)this.kernelDatabase.getDependencyResolver().resolveDependency(Kernel.class);
        }
    }
}

