/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database.readonly;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseContextProvider;
import org.neo4j.dbms.database.readonly.ReadOnlyDatabases;
import org.neo4j.dbms.systemgraph.CommunityTopologyGraphDbmsModel;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.database.DatabaseId;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;

public final class SystemGraphReadOnlyDatabaseLookupFactory
implements ReadOnlyDatabases.LookupFactory {
    private final DatabaseContextProvider<?> databaseContextProvider;
    private final InternalLog log;
    private volatile SystemGraphLookup previousLookup;

    public SystemGraphReadOnlyDatabaseLookupFactory(DatabaseContextProvider<?> databaseContextProvider, InternalLogProvider logProvider) {
        this.databaseContextProvider = databaseContextProvider;
        this.previousLookup = SystemGraphLookup.ALWAYS_READONLY;
        this.log = logProvider.getLog(this.getClass());
    }

    private Optional<GraphDatabaseAPI> systemDatabase() {
        Optional systemDb = this.databaseContextProvider.getDatabaseContext(NamedDatabaseId.NAMED_SYSTEM_DATABASE_ID);
        Boolean started = systemDb.map(db -> db.databaseFacade().isAvailable()).orElse(false);
        if (started.booleanValue()) {
            return systemDb.map(DatabaseContext::databaseFacade);
        }
        return Optional.empty();
    }

    public ReadOnlyDatabases.Lookup lookupReadOnlyDatabases() {
        SystemGraphLookup previous;
        SystemGraphLookup next = previous = this.previousLookup;
        try {
            next = this.systemDatabase().map(this::lookupReadOnlyDatabases).map(dbs -> new SystemGraphLookup((Set<DatabaseId>)dbs, false)).orElse(previous);
        }
        catch (Exception e) {
            this.log.warn("Unable to lookup readonly databases from the system database due to error! Using previous lookup %s.%nUnderlying error: %s", new Object[]{previous, e.getMessage()});
        }
        this.previousLookup = next;
        return next;
    }

    private Set<DatabaseId> lookupReadOnlyDatabases(GraphDatabaseAPI db) {
        try (Transaction tx = db.beginTx();){
            CommunityTopologyGraphDbmsModel model = new CommunityTopologyGraphDbmsModel(tx);
            Map databaseAccess = model.getAllDatabaseAccess();
            Set<DatabaseId> set = databaseAccess.entrySet().stream().filter(e -> e.getValue() == TopologyGraphDbmsModel.DatabaseAccess.READ_ONLY).map(e -> ((NamedDatabaseId)e.getKey()).databaseId()).collect(Collectors.toUnmodifiableSet());
            return set;
        }
    }

    private static class SystemGraphLookup
    implements ReadOnlyDatabases.Lookup {
        static final SystemGraphLookup ALWAYS_READONLY = new SystemGraphLookup(Set.of(), true);
        private final Set<DatabaseId> lookup;
        private final boolean alwaysReadOnly;

        SystemGraphLookup(Set<DatabaseId> lookup, boolean alwaysReadOnly) {
            this.lookup = lookup;
            this.alwaysReadOnly = alwaysReadOnly;
        }

        public boolean databaseIsReadOnly(DatabaseId databaseId) {
            return this.alwaysReadOnly || this.lookup.contains(databaseId);
        }

        public ReadOnlyDatabases.Lookup.Source source() {
            return ReadOnlyDatabases.Lookup.Source.SYSTEM_GRAPH;
        }

        public String toString() {
            return "SystemGraphLookup{readOnlyDatabases=" + this.lookup + ", alwaysReadOnly=" + this.alwaysReadOnly + "}";
        }
    }
}

