/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database.readonly;

import org.neo4j.dbms.database.readonly.ReadOnlyDatabases;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.event.TransactionEventListener;
import org.neo4j.graphdb.event.TransactionEventListenerAdapter;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.internal.event.GlobalTransactionEventListeners;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public final class SystemGraphReadOnlyListener
extends LifecycleAdapter {
    private final GlobalTransactionEventListeners txListeners;
    private final ReadOnlyDatabases readOnlyDatabases;
    private Listener listener;

    public SystemGraphReadOnlyListener(GlobalTransactionEventListeners txListeners, ReadOnlyDatabases readOnlyDatabases) {
        this.txListeners = txListeners;
        this.readOnlyDatabases = readOnlyDatabases;
    }

    public void start() throws Exception {
        this.listener = new Listener(this.readOnlyDatabases);
        this.txListeners.registerTransactionEventListener(NamedDatabaseId.NAMED_SYSTEM_DATABASE_ID.name(), (TransactionEventListener)this.listener);
    }

    public void stop() throws Exception {
        if (this.listener != null) {
            this.txListeners.unregisterTransactionEventListener(NamedDatabaseId.NAMED_SYSTEM_DATABASE_ID.name(), (TransactionEventListener)this.listener);
        }
    }

    private static class Listener
    extends TransactionEventListenerAdapter<Object> {
        private final ReadOnlyDatabases readOnlyDatabases;

        private Listener(ReadOnlyDatabases readOnlyDatabases) {
            this.readOnlyDatabases = readOnlyDatabases;
        }

        public void afterCommit(TransactionData data, Object state, GraphDatabaseService databaseService) {
            this.readOnlyDatabases.refresh();
        }
    }
}

