/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.systemgraph;

import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.AbstractSystemGraphComponent;
import org.neo4j.dbms.database.ComponentVersion;
import org.neo4j.dbms.database.KnownSystemComponentVersion;
import org.neo4j.dbms.database.KnownSystemComponentVersions;
import org.neo4j.dbms.database.SystemGraphComponent;
import org.neo4j.dbms.database.SystemGraphComponentWithVersion;
import org.neo4j.dbms.systemgraph.CommunityTopologyGraphVersion;
import org.neo4j.dbms.systemgraph.versions.CommunityTopologyComponentVersion_0_44;
import org.neo4j.dbms.systemgraph.versions.CommunityTopologyComponentVersion_1_50;
import org.neo4j.dbms.systemgraph.versions.CommunityTopologyComponentVersion_2_58;
import org.neo4j.dbms.systemgraph.versions.KnownCommunityTopologyComponentVersion;
import org.neo4j.dbms.systemgraph.versions.NoCommunityTopologyComponentVersion;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;

public class CommunityTopologyGraphComponent
extends AbstractSystemGraphComponent
implements SystemGraphComponentWithVersion {
    private final InternalLog log;
    private final KnownSystemComponentVersions<KnownCommunityTopologyComponentVersion> knownCommunityTopologyComponentVersions = new KnownSystemComponentVersions((KnownSystemComponentVersion)new NoCommunityTopologyComponentVersion());

    public CommunityTopologyGraphComponent(Config config, InternalLogProvider logProvider) {
        super(config);
        this.log = logProvider.getLog(((Object)((Object)this)).getClass());
        CommunityTopologyComponentVersion_0_44 version0 = new CommunityTopologyComponentVersion_0_44();
        CommunityTopologyComponentVersion_1_50 version1 = new CommunityTopologyComponentVersion_1_50();
        CommunityTopologyComponentVersion_2_58 version2 = new CommunityTopologyComponentVersion_2_58(version1);
        this.knownCommunityTopologyComponentVersions.add((KnownSystemComponentVersion)version0);
        this.knownCommunityTopologyComponentVersions.add((KnownSystemComponentVersion)version1);
        this.knownCommunityTopologyComponentVersions.add((KnownSystemComponentVersion)version2);
    }

    public SystemGraphComponent.Name componentName() {
        return ComponentVersion.COMMUNITY_TOPOLOGY_GRAPH_COMPONENT;
    }

    public int getLatestSupportedVersion() {
        return CommunityTopologyGraphVersion.LATEST_COMMUNITY_TOPOLOGY_VERSION;
    }

    public SystemGraphComponent.Status detect(Transaction tx) {
        return ((KnownCommunityTopologyComponentVersion)this.knownCommunityTopologyComponentVersions.detectCurrentComponentVersion(tx)).getStatus(this.config);
    }

    protected void initializeSystemGraphModel(Transaction tx, GraphDatabaseService systemDb) {
        KnownCommunityTopologyComponentVersion latest = (KnownCommunityTopologyComponentVersion)this.knownCommunityTopologyComponentVersions.latestComponentVersion();
        latest.setVersionProperty(tx, latest.version);
        latest.initializeTopologyGraph(tx);
    }

    public void upgradeToCurrent(GraphDatabaseService system) throws Exception {
        SystemGraphComponent.executeWithFullAccess((GraphDatabaseService)system, tx -> {
            KnownCommunityTopologyComponentVersion currentVersion = (KnownCommunityTopologyComponentVersion)this.knownCommunityTopologyComponentVersions.detectCurrentComponentVersion(tx);
            this.log.debug(String.format("Trying to upgrade component '%s' with version %d and status %s to latest version", ComponentVersion.COMMUNITY_TOPOLOGY_GRAPH_COMPONENT, currentVersion.version, currentVersion.getStatus(this.config)));
            if (currentVersion.version == -1) {
                this.log.debug("The current version does not have a community topology graph, doing a full initialization");
                this.initializeSystemGraphModel((Transaction)tx, system);
            } else if (currentVersion.migrationSupported()) {
                this.log.info(String.format("Upgrading '%s' component to latest version", ComponentVersion.COMMUNITY_TOPOLOGY_GRAPH_COMPONENT));
                ((KnownCommunityTopologyComponentVersion)this.knownCommunityTopologyComponentVersions.latestComponentVersion()).upgradeTopologyGraph((Transaction)tx, currentVersion.version);
            } else {
                throw currentVersion.unsupported();
            }
        });
    }
}

