/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.facade;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.neo4j.common.DependencyResolver;
import org.neo4j.graphdb.event.DatabaseEventListener;
import org.neo4j.graphdb.facade.ExternalDependencies;
import org.neo4j.graphdb.security.URLAccessRule;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.impl.security.URLAccessRules;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.monitoring.Monitors;
import org.neo4j.service.Services;

public class GraphDatabaseDependencies
implements ExternalDependencies {
    private Monitors monitors;
    private InternalLogProvider userLogProvider;
    private InternalLogProvider debugLogProvider;
    private DependencyResolver dependencies;
    private List<ExtensionFactory<?>> extensions;
    private List<DatabaseEventListener> databaseEventListeners;
    private final Map<String, URLAccessRule> urlAccessRules;

    public static GraphDatabaseDependencies newDependencies(ExternalDependencies deps) {
        return new GraphDatabaseDependencies(deps.monitors(), deps.userLogProvider(), deps.dependencies(), deps.extensions(), deps.urlAccessRules(), deps.databaseEventListeners());
    }

    public static GraphDatabaseDependencies newDependencies() {
        Iterable<ExtensionFactory<?>> extensions = GraphDatabaseDependencies.getExtensions(Services.loadAll(ExtensionFactory.class).iterator());
        HashMap<String, URLAccessRule> urlAccessRules = new HashMap<String, URLAccessRule>();
        urlAccessRules.put("http", URLAccessRules.webAccess());
        urlAccessRules.put("https", URLAccessRules.webAccess());
        urlAccessRules.put("ftp", URLAccessRules.webAccess());
        urlAccessRules.put("file", URLAccessRules.fileAccess());
        return new GraphDatabaseDependencies(null, null, null, extensions, urlAccessRules, Iterables.empty());
    }

    private GraphDatabaseDependencies(Monitors monitors, InternalLogProvider userLogProvider, DependencyResolver dependencies, Iterable<ExtensionFactory<?>> extensions, Map<String, URLAccessRule> urlAccessRules, Iterable<DatabaseEventListener> eventListeners) {
        this.monitors = monitors;
        this.userLogProvider = userLogProvider;
        this.dependencies = dependencies;
        this.extensions = Iterables.asList(extensions);
        this.urlAccessRules = urlAccessRules;
        this.databaseEventListeners = Iterables.asList(eventListeners);
    }

    public GraphDatabaseDependencies monitors(Monitors monitors) {
        this.monitors = monitors;
        return this;
    }

    public GraphDatabaseDependencies userLogProvider(InternalLogProvider userLogProvider) {
        this.userLogProvider = userLogProvider;
        return this;
    }

    public GraphDatabaseDependencies debugLogProvider(InternalLogProvider debugLogProvider) {
        this.debugLogProvider = debugLogProvider;
        return this;
    }

    public GraphDatabaseDependencies dependencies(DependencyResolver dependencies) {
        this.dependencies = dependencies;
        return this;
    }

    public GraphDatabaseDependencies databaseEventListeners(Iterable<DatabaseEventListener> eventListeners) {
        this.databaseEventListeners = Iterables.asList(eventListeners);
        return this;
    }

    public GraphDatabaseDependencies extensions(Iterable<ExtensionFactory<?>> extensions) {
        this.extensions = Iterables.asList(extensions);
        return this;
    }

    public GraphDatabaseDependencies urlAccessRules(Map<String, URLAccessRule> urlAccessRules) {
        this.urlAccessRules.putAll(urlAccessRules);
        return this;
    }

    @Override
    public Monitors monitors() {
        return this.monitors;
    }

    @Override
    public InternalLogProvider userLogProvider() {
        return this.userLogProvider;
    }

    public InternalLogProvider debugLogProvider() {
        return this.debugLogProvider;
    }

    @Override
    public Iterable<ExtensionFactory<?>> extensions() {
        return this.extensions;
    }

    @Override
    public Map<String, URLAccessRule> urlAccessRules() {
        return this.urlAccessRules;
    }

    @Override
    public Iterable<DatabaseEventListener> databaseEventListeners() {
        return this.databaseEventListeners;
    }

    @Override
    public DependencyResolver dependencies() {
        return this.dependencies;
    }

    private static Iterable<ExtensionFactory<?>> getExtensions(final Iterator<ExtensionFactory> parent) {
        return Iterators.asList((Iterator)new Iterator<ExtensionFactory<?>>(){

            @Override
            public boolean hasNext() {
                return parent.hasNext();
            }

            @Override
            public ExtensionFactory<?> next() {
                return (ExtensionFactory)parent.next();
            }
        });
    }
}

