/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.facade;

import java.util.concurrent.TimeUnit;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.ProgressReporter;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseContextProvider;
import org.neo4j.dbms.database.DbmsRuntimeRepository;
import org.neo4j.dbms.database.DbmsRuntimeSystemGraphComponent;
import org.neo4j.dbms.database.SystemGraphComponent;
import org.neo4j.dbms.database.SystemGraphComponents;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.event.DatabaseEventListener;
import org.neo4j.graphdb.facade.GraphDatabaseDependencies;
import org.neo4j.graphdb.factory.module.GlobalModule;
import org.neo4j.graphdb.factory.module.edition.AbstractEditionModule;
import org.neo4j.graphdb.factory.module.edition.migration.MigrationEditionModuleFactory;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.kernel.api.security.provider.SecurityProvider;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.kernel.impl.storemigration.VisibleMigrationProgressMonitorFactory;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.internal.event.GlobalTransactionEventListeners;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.SimpleLogService;
import org.neo4j.procedure.impl.GlobalProceduresRegistry;
import org.neo4j.storageengine.migration.MigrationProgressMonitor;

public class SystemDbUpgrader {
    private SystemDbUpgrader() {
    }

    public static void upgrade(MigrationEditionModuleFactory editionFactory, Config config, InternalLogProvider logProvider, final InternalLogProvider systemDbStartupLogProvider, DatabaseEventListener eventListener) throws Exception {
        MigrationProgressMonitor progressMonitor = VisibleMigrationProgressMonitorFactory.forSystemUpgrade((InternalLog)logProvider.getLog(SystemDbUpgrader.class));
        progressMonitor.started(3);
        ProgressReporter bootstrapProgress = progressMonitor.startSection("Bootstrap");
        GraphDatabaseDependencies graphDatabaseDependencies = SystemDbUpgrader.dependenciesWithoutExtensions(eventListener).databaseEventListeners(Iterables.iterable((Object[])new DatabaseEventListener[]{eventListener}));
        GlobalModule globalModule = new GlobalModule(config, DbmsInfo.TOOL, false, graphDatabaseDependencies){

            @Override
            protected LogService createLogService(InternalLogProvider userLogProvider, boolean daemonMode) {
                return new SimpleLogService(systemDbStartupLogProvider);
            }

            @Override
            protected GlobalTransactionEventListeners createGlobalTransactionEventListeners() {
                return GlobalTransactionEventListeners.NULL;
            }
        };
        AbstractEditionModule edition = (AbstractEditionModule)editionFactory.apply(globalModule);
        Dependencies globalDependencies = globalModule.getGlobalDependencies();
        LifeSupport globalLife = globalModule.getGlobalLife();
        globalModule.getGlobalDependencies().satisfyDependency((Object)new GlobalProceduresRegistry());
        SystemGraphComponents.DefaultBuilder systemGraphComponentsBuilder = new SystemGraphComponents.DefaultBuilder();
        DbmsRuntimeSystemGraphComponent dbmsRuntimeSystemGraphComponent = new DbmsRuntimeSystemGraphComponent(globalModule.getGlobalConfig());
        systemGraphComponentsBuilder.register((SystemGraphComponent)dbmsRuntimeSystemGraphComponent);
        edition.registerSystemGraphComponents((SystemGraphComponents.Builder)systemGraphComponentsBuilder, globalModule);
        DatabaseContextProvider databaseContextProvider = edition.createDatabaseContextProvider(globalModule);
        edition.bootstrapQueryRouterServices(null);
        edition.registerDatabaseInitializers(globalModule);
        edition.createDefaultDatabaseResolver(globalModule);
        globalDependencies.satisfyDependency((Object)edition.getDefaultDatabaseResolver());
        edition.createSecurityModule(globalModule);
        SecurityProvider securityProvider = edition.getSecurityProvider();
        globalDependencies.satisfyDependencies(new Object[]{securityProvider.authManager()});
        DbmsRuntimeRepository dbmsRuntimeRepository = edition.createAndRegisterDbmsRuntimeRepository(globalModule, databaseContextProvider, globalDependencies, dbmsRuntimeSystemGraphComponent);
        globalDependencies.satisfyDependency((Object)dbmsRuntimeRepository);
        globalLife.start();
        DatabaseContext systemContext = (DatabaseContext)databaseContextProvider.getDatabaseContext(NamedDatabaseId.NAMED_SYSTEM_DATABASE_ID).orElseThrow(() -> new IllegalStateException("Could not start System database for upgrade."));
        GraphDatabaseAPI systemDb = systemContext.databaseFacade();
        bootstrapProgress.completed();
        ProgressReporter indexPopulationProgress = progressMonitor.startSection("Index population");
        try (Transaction tx = systemDb.beginTx();){
            tx.schema().awaitIndexesOnline(1L, TimeUnit.HOURS);
        }
        catch (IllegalStateException e) {
            try {
                globalLife.shutdown();
            }
            catch (Exception toSuppress) {
                throw (Exception)Exceptions.chain((Throwable)e, (Throwable)toSuppress);
            }
            throw e;
        }
        indexPopulationProgress.completed();
        globalLife.shutdown();
        progressMonitor.completed();
    }

    private static GraphDatabaseDependencies dependenciesWithoutExtensions(DatabaseEventListener eventListener) {
        return GraphDatabaseDependencies.newDependencies().extensions(Iterables.empty());
    }
}

