/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.neo4j.server.Bootstrapper;

public class BlockingBootstrapper
implements Bootstrapper {
    private final Bootstrapper wrapped;
    private final CountDownLatch latch;

    public BlockingBootstrapper(Bootstrapper wrapped) {
        this.wrapped = wrapped;
        this.latch = new CountDownLatch(1);
    }

    public final int start(Path homeDir, Map<String, String> configOverrides) {
        return this.start(homeDir, null, configOverrides, false, false);
    }

    @Override
    public final int start(Path homeDir, Path configFile, Map<String, String> configOverrides, boolean expandCommands, boolean daemonMode) {
        int status = this.wrapped.start(homeDir, configFile, configOverrides, expandCommands, daemonMode);
        if (status != 0) {
            return status;
        }
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return this.wrapped.stop();
    }

    @Override
    public int stop() {
        this.latch.countDown();
        return 0;
    }
}

