/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.management.MemoryUsage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.SystemUtils;
import org.neo4j.configuration.BootloaderSettings;
import org.neo4j.configuration.BufferingLog;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.HttpConnector;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.facade.GraphDatabaseDependencies;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.kernel.internal.Version;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.log4j.Log4jLogProvider;
import org.neo4j.logging.log4j.LogConfig;
import org.neo4j.logging.log4j.Neo4jLoggerContext;
import org.neo4j.logging.log4j.SystemLogger;
import org.neo4j.memory.MachineMemory;
import org.neo4j.server.Bootstrapper;
import org.neo4j.server.CommandLineArgs;
import org.neo4j.server.HeapDumpDiagnostics;
import org.neo4j.server.ServerStartupException;
import org.neo4j.server.logging.JULBridge;
import org.neo4j.server.startup.PidFileHelper;
import org.neo4j.util.FeatureToggles;
import org.neo4j.util.VisibleForTesting;
import sun.misc.Signal;

public abstract class NeoBootstrapper
implements Bootstrapper {
    public static final String SIGTERM = "TERM";
    public static final String SIGINT = "INT";
    public static final int OK = 0;
    public static final int WEB_SERVER_STARTUP_ERROR_CODE = 1;
    public static final int GRAPH_DATABASE_STARTUP_ERROR_CODE = 2;
    public static final int INVALID_CONFIGURATION_ERROR_CODE = 3;
    public static final int LICENSE_NOT_ACCEPTED_ERROR_CODE = 4;
    private static final String NEO4J_SLF4J_PROVIDER = "org.neo4j.server.logging.slf4j.SLF4JLogBridge";
    private static final boolean USE_NEO4J_SLF4J_PROVIDER = FeatureToggles.flag(Bootstrapper.class, (String)"useNeo4jSlf4jProvider", (boolean)false);
    private static final HeapDumpDiagnostics HEAPDUMP_DIAGNOSTICS = HeapDumpDiagnostics.INSTANCE;
    private volatile DatabaseManagementService databaseManagementService;
    private volatile Closeable userLogFileStream;
    private Thread shutdownHook;
    private GraphDatabaseDependencies dependencies = GraphDatabaseDependencies.newDependencies();
    private final BufferingLog startupLog = new BufferingLog();
    private volatile InternalLog log = this.startupLog;
    private String serverAddress = "unknown address";
    private String serverLocation = "unknown location";
    private MachineMemory machineMemory = MachineMemory.DEFAULT;
    private Path pidFile;

    public static int start(Bootstrapper boot, String ... argv) {
        CommandLineArgs args = CommandLineArgs.parse(argv);
        if (args.homeDir == null) {
            throw new ServerStartupException("Argument --home-dir is required and was not provided.");
        }
        return boot.start(args.homeDir, args.configFile, args.configOverrides, args.expandCommands, !args.consoleMode);
    }

    @VisibleForTesting
    public final int start(Path homeDir, Map<String, String> configOverrides) {
        return this.start(homeDir, null, configOverrides, false, false);
    }

    @Override
    public final int start(Path homeDir, Path configFile, Map<String, String> configOverrides, boolean expandCommands, boolean daemonMode) {
        this.addShutdownHook();
        NeoBootstrapper.installSignalHandlers();
        SystemLogger.installErrorListener();
        Config config = Config.newBuilder().commandExpansion(expandCommands).setDefaults(GraphDatabaseSettings.SERVER_DEFAULTS).fromFileNoThrow(configFile).setRaw(configOverrides).set(GraphDatabaseSettings.neo4j_home, (Object)homeDir.toAbsolutePath()).build();
        HeapDumpDiagnostics.INSTANCE.START_TIME = Instant.now().toString();
        HeapDumpDiagnostics.INSTANCE.NEO4J_VERSION = Version.getNeo4jVersion();
        this.pidFile = (Path)config.get(BootloaderSettings.pid_file);
        this.writePidSilently();
        Log4jLogProvider userLogProvider = NeoBootstrapper.setupLogging(config, daemonMode);
        this.userLogFileStream = userLogProvider;
        this.dependencies = this.dependencies.userLogProvider((InternalLogProvider)userLogProvider);
        this.log = userLogProvider.getLog(this.getClass());
        boolean startAllowed = this.checkLicenseAgreement(homeDir, (Configuration)config, daemonMode);
        this.startupLog.replayInto(this.log);
        config.setLogger(this.log);
        if (SystemLogger.errorsEncounteredDuringSetup()) {
            return 3;
        }
        if (!startAllowed) {
            return 4;
        }
        if (this.requestedMemoryExceedsAvailable(config)) {
            this.log.error(String.format("Invalid memory configuration - exceeds physical memory. Check the configured values for %s and %s", GraphDatabaseSettings.pagecache_memory.name(), BootloaderSettings.max_heap_size.name()));
            return 3;
        }
        if (daemonMode) {
            System.err.println('\u0006');
            PrintStream oldErr = System.err;
            PrintStream oldOut = System.out;
            SystemLogger.installStdRedirects((InternalLogProvider)userLogProvider);
            IOUtils.closeAllUnchecked((AutoCloseable[])new PrintStream[]{oldErr, oldOut});
        }
        try {
            this.serverAddress = ((SocketAddress)config.get(HttpConnector.listen_address)).toString();
            this.serverLocation = ((Path)config.get(GraphDatabaseInternalSettings.databases_root_path)).toString();
            this.log.info("Starting...");
            this.databaseManagementService = this.createNeo(config, daemonMode, this.dependencies);
            this.log.info("Started.");
            return 0;
        }
        catch (ServerStartupException e) {
            e.describeTo(this.log);
            return 1;
        }
        catch (TransactionFailureException tfe) {
            this.log.error(String.format("Failed to start Neo4j on %s. Another process may be using databases at location: %s", this.serverAddress, this.serverLocation), (Throwable)tfe);
            return 2;
        }
        catch (Exception e) {
            this.log.error(String.format("Failed to start Neo4j on %s.", this.serverAddress), (Throwable)e);
            return 1;
        }
    }

    private void writePidSilently() {
        if (!SystemUtils.IS_OS_WINDOWS) {
            try {
                Long currentPid = ProcessHandle.current().pid();
                Long pid = PidFileHelper.readPid(this.pidFile);
                if (!currentPid.equals(pid)) {
                    PidFileHelper.storePid(this.pidFile, currentPid);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void deletePidSilently() {
        if (!SystemUtils.IS_OS_WINDOWS && this.pidFile != null) {
            PidFileHelper.remove(this.pidFile);
        }
    }

    private boolean requestedMemoryExceedsAvailable(Config config) {
        Long pageCacheMemory = (Long)config.get(GraphDatabaseSettings.pagecache_memory);
        long pageCacheSize = pageCacheMemory == null ? ConfiguringPageCacheFactory.defaultHeuristicPageCacheMemory((MachineMemory)this.machineMemory) : pageCacheMemory;
        MemoryUsage heapMemoryUsage = this.machineMemory.getHeapMemoryUsage();
        long totalPhysicalMemory = this.machineMemory.getTotalPhysicalMemory();
        if (totalPhysicalMemory == 0L) {
            this.log.warn("Unable to determine total physical memory of machine. JVM is most likely running in a container that do not expose that.");
            return false;
        }
        return totalPhysicalMemory != -1L && pageCacheSize + heapMemoryUsage.getMax() > totalPhysicalMemory;
    }

    @Override
    public int stop() {
        try {
            this.doShutdown();
            this.removeShutdownHook();
            this.closeUserLogFileStream();
            return 0;
        }
        catch (Exception e) {
            this.switchToErrorLoggingIfLoggingNotConfigured();
            this.log.error("Failed to cleanly shutdown Neo Server on port [%s], database [%s]. Reason [%s] ", new Object[]{this.serverAddress, this.serverLocation, e.getMessage(), e});
            this.closeUserLogFileStream();
            return 1;
        }
    }

    public boolean isRunning() {
        return this.databaseManagementService != null;
    }

    public DatabaseManagementService getDatabaseManagementService() {
        return this.databaseManagementService;
    }

    public InternalLog getLog() {
        return this.log;
    }

    protected abstract DatabaseManagementService createNeo(Config var1, boolean var2, GraphDatabaseDependencies var3);

    protected abstract boolean checkLicenseAgreement(Path var1, Configuration var2, boolean var3);

    private static Log4jLogProvider setupLogging(Config config, boolean daemonMode) {
        Path xmlConfig = (Path)config.get(GraphDatabaseSettings.user_logging_config_path);
        boolean allowDefaultXmlConfig = !config.isExplicitlySet(GraphDatabaseSettings.user_logging_config_path);
        Neo4jLoggerContext ctx = LogConfig.createLoggerFromXmlConfig((FileSystemAbstraction)new DefaultFileSystemAbstraction(), (Path)xmlConfig, (boolean)allowDefaultXmlConfig, (boolean)daemonMode, arg_0 -> ((Config)config).configStringLookup(arg_0), null, null);
        Log4jLogProvider userLogProvider = new Log4jLogProvider(ctx);
        JULBridge.resetJUL();
        Logger.getLogger("").setLevel(Level.WARNING);
        JULBridge.forwardTo((InternalLogProvider)userLogProvider);
        NeoBootstrapper.setupSLF4JProvider(userLogProvider, List.of("org.eclipse.jetty"), "WARN");
        return userLogProvider;
    }

    private static void setupSLF4JProvider(Log4jLogProvider userLogProvider, List<String> prefixFilters, String level) {
        if (!USE_NEO4J_SLF4J_PROVIDER) {
            return;
        }
        try {
            Class<?> bridge = Class.forName(NEO4J_SLF4J_PROVIDER);
            Method setLogProvider = bridge.getMethod("setInstantiationContext", Log4jLogProvider.class, List.class, String.class);
            setLogProvider.invoke(null, userLogProvider, prefixFilters, level);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            userLogProvider.getLog(NEO4J_SLF4J_PROVIDER).info("Neo4j SLF4J provider not found. Libraries that uses SLF4J, e.g. Jetty, will not be able to write the the Neo4j log files.");
            userLogProvider.getLog(NEO4J_SLF4J_PROVIDER).debug("Details: ", (Throwable)e);
        }
    }

    private static void installSignalHandlers() {
        NeoBootstrapper.installSignalHandler(SIGTERM, false);
        NeoBootstrapper.installSignalHandler(SIGINT, true);
    }

    private static void installSignalHandler(String sig, boolean tolerateErrors) {
        block2: {
            try {
                Signal.handle(new Signal(sig), signal -> System.exit(0));
            }
            catch (Throwable e) {
                if (tolerateErrors) break block2;
                throw e;
            }
        }
    }

    private void doShutdown() {
        this.switchToErrorLoggingIfLoggingNotConfigured();
        if (this.databaseManagementService != null) {
            this.log.info("Stopping...");
            this.databaseManagementService.shutdown();
        }
        this.deletePidSilently();
        this.log.info("Stopped.");
    }

    private void closeUserLogFileStream() {
        if (this.userLogFileStream != null) {
            IOUtils.closeAllUnchecked((AutoCloseable[])new Closeable[]{this.userLogFileStream});
        }
    }

    private void addShutdownHook() {
        this.shutdownHook = new Thread(() -> {
            this.log.info("Neo4j Server shutdown initiated by request");
            this.doShutdown();
            this.closeUserLogFileStream();
        });
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    private void removeShutdownHook() {
        if (this.shutdownHook != null && !Runtime.getRuntime().removeShutdownHook(this.shutdownHook)) {
            this.log.warn("Unable to remove shutdown hook");
        }
    }

    private void switchToErrorLoggingIfLoggingNotConfigured() {
        if (this.userLogFileStream == null) {
            Log4jLogProvider outProvider = new Log4jLogProvider((OutputStream)System.out);
            this.userLogFileStream = outProvider;
            this.log = outProvider.getLog(this.getClass());
            this.startupLog.replayInto(this.log);
        }
    }

    @VisibleForTesting
    void setMachineMemory(MachineMemory machineMemory) {
        this.machineMemory = machineMemory;
    }
}

