/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.startup.validation;

import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Reconfigurable;
import org.apache.logging.log4j.core.config.xml.XmlConfiguration;
import org.apache.logging.log4j.core.util.NullOutputStream;
import org.apache.logging.log4j.status.StatusData;
import org.apache.logging.log4j.status.StatusListener;
import org.apache.logging.log4j.status.StatusLogger;
import org.neo4j.configuration.Config;
import org.neo4j.internal.helpers.ArrayUtil;
import org.neo4j.logging.log4j.AbstractLookup;
import org.neo4j.logging.log4j.LookupContext;
import org.neo4j.server.startup.validation.ConfigValidationIssue;
import org.neo4j.server.startup.validation.ConfigValidator;
import org.neo4j.util.VisibleForTesting;
import org.xml.sax.SAXParseException;

public class Log4jConfigValidator
implements ConfigValidator {
    private final Path path;
    private final Config config;
    private final String label;
    static final String[] NONSENSE_ERRORS = new String[]{"No logging configuration"};

    public Log4jConfigValidator(Supplier<Config> config, String label, Path path) {
        this.config = config.get();
        this.path = path;
        this.label = label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ConfigValidationIssue> validate() throws IOException {
        StatusLogger logger = StatusLogger.getLogger();
        PrintStream oldOut = System.out;
        PrintStream oldErr = System.err;
        ArrayList<ConfigValidationIssue> issues = new ArrayList<ConfigValidationIssue>();
        StatusListener statusListener = this.createIssueCollectingStatusListener(issues);
        try {
            System.setOut(new PrintStream(NullOutputStream.nullOutputStream()));
            System.setErr(new PrintStream(NullOutputStream.nullOutputStream()));
            logger.registerListener(statusListener);
            AbstractLookup.setLookupContext((LookupContext)new LookupContext(null, null, arg_0 -> ((Config)this.config).configStringLookup(arg_0)));
            this.loadConfig(this.path);
        }
        finally {
            AbstractLookup.removeLookupContext();
            logger.clear();
            logger.removeListener(statusListener);
            System.setOut(oldOut);
            System.setErr(oldErr);
        }
        return issues;
    }

    private StatusListener createIssueCollectingStatusListener(final List<ConfigValidationIssue> issues) {
        return new StatusListener(){

            public void close() {
            }

            public void log(StatusData status) {
                String message = status.getMessage().getFormattedMessage();
                Throwable throwable = status.getThrowable();
                if (throwable instanceof SAXParseException) {
                    message = throwable.getMessage();
                }
                if (!ArrayUtil.contains((Object[])NONSENSE_ERRORS, (Object)message)) {
                    issues.add(new ConfigValidationIssue(Log4jConfigValidator.this.path, message, true, throwable));
                }
            }

            public Level getStatusLevel() {
                return Level.ERROR;
            }
        };
    }

    @VisibleForTesting
    void loadConfig(Path path) {
        ConfigurationSource source = ConfigurationSource.fromUri((URI)path.toUri());
        if (source != null) {
            XmlConfigValidator config = new XmlConfigValidator(source);
            config.initialize();
            config.start();
            config.stop();
        }
    }

    @Override
    public String getLabel() {
        return "%s Log4j configuration: %s".formatted(this.label, this.path.toString());
    }

    private static class XmlConfigValidator
    extends XmlConfiguration {
        public XmlConfigValidator(ConfigurationSource source) {
            super(null, source);
        }

        protected void initializeWatchers(Reconfigurable reconfigurable, ConfigurationSource configSource, int monitorIntervalSeconds) {
        }
    }
}

