/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.startup.validation;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.neo4j.cli.CommandFailedException;
import org.neo4j.configuration.Config;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.Neo4jLogMessage;
import org.neo4j.logging.Neo4jMessageSupplier;
import org.neo4j.server.startup.validation.ConfigValidationIssue;
import org.neo4j.server.startup.validation.ConfigValidator;
import org.neo4j.util.VisibleForTesting;

public class Neo4jConfigValidator
implements ConfigValidator {
    private final Path path;
    private final Supplier<Config> configSupplier;

    public Neo4jConfigValidator(Supplier<Config> config, Path path) {
        this.configSupplier = config;
        this.path = path;
    }

    @Override
    public List<ConfigValidationIssue> validate() {
        ArrayList<ConfigValidationIssue> issues = new ArrayList<ConfigValidationIssue>();
        try {
            Config config = this.configSupplier.get();
            IssueCollectingLogger logger = new IssueCollectingLogger(issues);
            config.setLogger((InternalLog)logger);
        }
        catch (IllegalArgumentException e) {
            issues.add(new ConfigValidationIssue(this.path, e.getMessage(), true, e));
        }
        catch (CommandFailedException e) {
            String message = e.getMessage();
            Throwable cause = e.getCause();
            if (cause != null) {
                message = cause.getMessage();
            }
            issues.add(new ConfigValidationIssue(this.path, message, true, e));
        }
        return issues;
    }

    @Override
    public String getLabel() {
        if (this.path != null) {
            return "Neo4j configuration: %s".formatted(this.path.toString());
        }
        return "Neo4j configuration";
    }

    @VisibleForTesting
    static class IssueCollectingLogger
    implements InternalLog {
        private final List<ConfigValidationIssue> issues;

        public IssueCollectingLogger(List<ConfigValidationIssue> issues) {
            this.issues = issues;
        }

        public void debug(Neo4jLogMessage message) {
        }

        public void debug(Neo4jMessageSupplier supplier) {
        }

        public void info(Neo4jLogMessage message) {
        }

        public void info(Neo4jMessageSupplier supplier) {
        }

        public void warn(Neo4jLogMessage message) {
            this.warn(message.getFormattedMessage(), message.getThrowable());
        }

        public void warn(Neo4jMessageSupplier supplier) {
            this.warn(supplier.get());
        }

        public void error(Neo4jLogMessage message) {
            this.error(message, message.getThrowable());
        }

        public void error(Neo4jMessageSupplier supplier) {
            this.error(supplier.get());
        }

        public void error(Neo4jLogMessage message, Throwable throwable) {
            this.error(message.getFormattedMessage(), throwable);
        }

        public boolean isDebugEnabled() {
            return false;
        }

        public void debug(String message) {
        }

        public void debug(String message, Throwable throwable) {
        }

        public void debug(String format, Object ... arguments) {
        }

        public void info(String message) {
        }

        public void info(String message, Throwable throwable) {
        }

        public void info(String format, Object ... arguments) {
        }

        public void warn(String message) {
            this.warn(Neo4jMessageSupplier.forMessage((String)message, (Object[])new Object[0]));
        }

        public void warn(String message, Throwable throwable) {
            this.issues.add(new ConfigValidationIssue(null, message, false, throwable));
        }

        public void warn(String format, Object ... arguments) {
            this.warn(Neo4jMessageSupplier.forMessage((String)format, (Object[])arguments));
        }

        public void error(String message) {
            this.error(Neo4jMessageSupplier.forMessage((String)message, (Object[])new Object[0]));
        }

        public void error(String message, Throwable throwable) {
            this.issues.add(new ConfigValidationIssue(null, message, true, throwable));
        }

        public void error(String format, Object ... arguments) {
            this.error(Neo4jMessageSupplier.forMessage((String)format, (Object[])arguments));
        }
    }
}

