/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id.indexed;

import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.internal.id.indexed.IdRange;
import org.neo4j.internal.id.indexed.IdRangeKey;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.util.Preconditions;

public class IdRangeLayout
extends Layout.Adapter<IdRangeKey, IdRange> {
    private final int longsPerEntry;
    private final int idsPerEntry;

    public IdRangeLayout(int idsPerEntry) {
        super(true, 3735929054L + (long)idsPerEntry, 1, 2);
        this.idsPerEntry = idsPerEntry;
        Preconditions.requirePowerOfTwo((long)idsPerEntry);
        this.longsPerEntry = (idsPerEntry - 1) / 64 + 1;
    }

    public IdRangeKey newKey() {
        return new IdRangeKey(0L);
    }

    public IdRangeKey copyKey(IdRangeKey key, IdRangeKey into) {
        into.setIdRangeIdx(key.getIdRangeIdx());
        return into;
    }

    public IdRange newValue() {
        return new IdRange(this.longsPerEntry, this.idsPerEntry);
    }

    public int keySize(IdRangeKey key) {
        return 8;
    }

    public int valueSize(IdRange ignore) {
        return 8 + this.longsPerEntry * 8 * 3;
    }

    public void writeKey(PageCursor cursor, IdRangeKey key) {
        cursor.putLong(key.getIdRangeIdx());
    }

    public void writeValue(PageCursor cursor, IdRange value) {
        cursor.putLong(value.getGeneration());
        IdRangeLayout.writeLongs(cursor, value.getBitSets());
    }

    public void readKey(PageCursor cursor, IdRangeKey into, int keySize) {
        into.setIdRangeIdx(cursor.getLong());
    }

    public void readValue(PageCursor cursor, IdRange into, int ignore) {
        into.setGeneration(cursor.getLong());
        IdRangeLayout.readLongs(cursor, into.getBitSets());
    }

    public void initializeAsLowest(IdRangeKey idRangeKey) {
        idRangeKey.setIdRangeIdx(Long.MIN_VALUE);
    }

    public void initializeAsHighest(IdRangeKey idRangeKey) {
        idRangeKey.setIdRangeIdx(Long.MAX_VALUE);
    }

    private static void writeLongs(PageCursor cursor, long[][] groups) {
        long[][] lArray = groups;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            long[] group;
            for (long bits : group = lArray[i]) {
                cursor.putLong(bits);
            }
        }
    }

    private static void readLongs(PageCursor cursor, long[][] groups) {
        for (int i = 0; i < groups.length; ++i) {
            long[] group = groups[i];
            for (int ii = 0; ii < group.length; ++ii) {
                group[ii] = cursor.getLong();
            }
        }
    }

    public int compare(IdRangeKey o1, IdRangeKey o2) {
        return Long.compare(o1.getIdRangeIdx(), o2.getIdRangeIdx());
    }

    long idRangeIndex(long id) {
        return id / (long)this.idsPerEntry;
    }

    int idsPerEntry() {
        return this.idsPerEntry;
    }
}

