/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.storageengine.util.IdUpdateListener;
import org.neo4j.util.concurrent.AsyncApply;
import org.neo4j.util.concurrent.Work;
import org.neo4j.util.concurrent.WorkSync;

public class IdGeneratorUpdatesWorkSync {
    public static final String ID_GENERATOR_BATCH_APPLIER_TAG = "idGeneratorBatchApplier";
    private final Map<IdGenerator, WorkSync<IdGenerator, IdGeneratorUpdateWork>> workSyncMap = new HashMap<IdGenerator, WorkSync<IdGenerator, IdGeneratorUpdateWork>>();
    private final boolean alwaysFreeOnDelete;

    public IdGeneratorUpdatesWorkSync() {
        this(false);
    }

    public IdGeneratorUpdatesWorkSync(boolean alwaysFreeOnDelete) {
        this.alwaysFreeOnDelete = alwaysFreeOnDelete;
    }

    public void add(IdGenerator idGenerator) {
        this.workSyncMap.put(idGenerator, (WorkSync<IdGenerator, IdGeneratorUpdateWork>)new WorkSync((Object)idGenerator));
    }

    public Batch newBatch(CursorContext cursorContext) {
        return new Batch(cursorContext);
    }

    public class Batch
    implements IdUpdateListener {
        private final Map<IdGenerator, ChangedIds> idUpdatesMap = new HashMap<IdGenerator, ChangedIds>();
        private final CursorContext cursorContext;

        protected Batch(CursorContext cursorContext) {
            this.cursorContext = cursorContext;
        }

        @Override
        public void markIdAsUsed(IdGenerator idGenerator, long id, int size, CursorContext cursorContext) {
            this.idUpdatesMap.computeIfAbsent(idGenerator, this::createChangedIds).addUsedId(id, size);
        }

        @Override
        public void markIdAsUnused(IdGenerator idGenerator, long id, int size, CursorContext cursorContext) {
            this.idUpdatesMap.computeIfAbsent(idGenerator, this::createChangedIds).addUnusedId(id, size);
        }

        public AsyncApply applyAsync() {
            if (this.idUpdatesMap.isEmpty()) {
                return AsyncApply.EMPTY;
            }
            this.applyInternal();
            return this::awaitApply;
        }

        public void apply() throws ExecutionException {
            if (!this.idUpdatesMap.isEmpty()) {
                this.applyInternal();
                this.awaitApply();
            }
        }

        private void awaitApply() throws ExecutionException {
            for (Map.Entry<IdGenerator, ChangedIds> idChanges : this.idUpdatesMap.entrySet()) {
                ChangedIds unit = idChanges.getValue();
                unit.awaitApply();
            }
        }

        private void applyInternal() {
            for (Map.Entry<IdGenerator, ChangedIds> idChanges : this.idUpdatesMap.entrySet()) {
                ChangedIds unit = idChanges.getValue();
                unit.applyAsync(IdGeneratorUpdatesWorkSync.this.workSyncMap.get(idChanges.getKey()));
            }
        }

        @Override
        public void close() throws Exception {
            this.apply();
        }

        private ChangedIds createChangedIds(IdGenerator ignored) {
            return new ChangedIds(IdGeneratorUpdatesWorkSync.this.alwaysFreeOnDelete, this.cursorContext);
        }
    }

    private static class IdGeneratorUpdateWork
    implements Work<IdGenerator, IdGeneratorUpdateWork> {
        private final List<ChangedIds> changeList = new ArrayList<ChangedIds>();

        IdGeneratorUpdateWork(ChangedIds changes) {
            this.changeList.add(changes);
        }

        public IdGeneratorUpdateWork combine(IdGeneratorUpdateWork work) {
            this.changeList.addAll(work.changeList);
            return this;
        }

        public void apply(IdGenerator idGenerator) {
            for (ChangedIds changes : this.changeList) {
                IdGenerator.TransactionalMarker marker = idGenerator.transactionalMarker(changes.cursorContext.createRelatedContext(IdGeneratorUpdatesWorkSync.ID_GENERATOR_BATCH_APPLIER_TAG));
                try {
                    changes.accept(marker);
                }
                finally {
                    if (marker == null) continue;
                    marker.close();
                }
            }
        }
    }

    private static class ChangedIds {
        private final MutableLongList ids = LongLists.mutable.empty();
        private final boolean freeOnDelete;
        private final CursorContext cursorContext;
        private AsyncApply asyncApply;

        ChangedIds(boolean freeOnDelete, CursorContext cursorContext) {
            this.freeOnDelete = freeOnDelete;
            this.cursorContext = cursorContext;
        }

        private void addUsedId(long id, int numberOfIds) {
            this.ids.add(IdUtils.combinedIdAndNumberOfIds((long)id, (int)numberOfIds, (boolean)true));
        }

        private void addUnusedId(long id, int numberOfIds) {
            this.ids.add(IdUtils.combinedIdAndNumberOfIds((long)id, (int)numberOfIds, (boolean)false));
        }

        void accept(IdGenerator.TransactionalMarker visitor) {
            this.ids.forEach((LongProcedure & Serializable)combined -> {
                long id = IdUtils.idFromCombinedId((long)combined);
                int slots = IdUtils.numberOfIdsFromCombinedId((long)combined);
                if (IdUtils.usedFromCombinedId((long)combined)) {
                    visitor.markUsed(id, slots);
                } else if (this.freeOnDelete) {
                    visitor.markDeletedAndFree(id, slots);
                } else {
                    visitor.markDeleted(id, slots);
                }
            });
        }

        void applyAsync(WorkSync<IdGenerator, IdGeneratorUpdateWork> workSync) {
            this.asyncApply = workSync.applyAsync((Work)new IdGeneratorUpdateWork(this));
        }

        void awaitApply() throws ExecutionException {
            this.asyncApply.await();
        }
    }
}

