/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import java.util.UUID;
import org.neo4j.common.EntityType;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.values.ElementIdMapper;

public class DefaultElementIdMapper
extends ElementIdMapper {
    private final UUID databaseId;

    public DefaultElementIdMapper(NamedDatabaseId databaseId) {
        this.databaseId = databaseId.databaseId().uuid();
    }

    public String nodeElementId(long nodeId) {
        return this.buildElementId(EntityType.NODE, this.ELEMENT_ID_FORMAT_VERSION, nodeId);
    }

    public long nodeId(String id) {
        return this.decodeElementId(id, EntityType.NODE);
    }

    public String relationshipElementId(long relationshipId) {
        return this.buildElementId(EntityType.RELATIONSHIP, this.ELEMENT_ID_FORMAT_VERSION, relationshipId);
    }

    public long relationshipId(String id) {
        return this.decodeElementId(id, EntityType.RELATIONSHIP);
    }

    private String buildElementId(EntityType entityType, byte elementIdFormatVersion, long id) {
        return this.buildElementIdByteArrayHeader(entityType, elementIdFormatVersion) + ":" + this.databaseId + ":" + id;
    }

    private long decodeElementId(String id, EntityType entityType) {
        try {
            ElementIdMapper.ElementId elementId = this.decode(id, entityType);
            this.verifyDatabaseId(elementId.databaseId(), id);
            return elementId.entityId();
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Element ID %s has an unexpected format.", id), e);
        }
    }

    private void verifyDatabaseId(UUID providedDatabaseId, String id) {
        if (!this.databaseId.equals(providedDatabaseId)) {
            throw new IllegalArgumentException(String.format("Element ID %s does not belong to the current database %s.", id, this.databaseId));
        }
    }

    private byte buildElementIdByteArrayHeader(EntityType entityType, byte version) {
        byte header = 0;
        header = (byte)(header | (entityType != EntityType.NODE ? 1 : 0));
        header = (byte)(header | version << 2);
        return header;
    }
}

