/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.io.IOException;
import org.neo4j.dbms.database.DatabasePageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.DatabaseFlushEvent;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointerImpl;
import org.neo4j.storageengine.api.StorageEngine;

public class DefaultForceOperation
implements CheckPointerImpl.ForceOperation {
    private final IndexingService indexingService;
    private final StorageEngine storageEngine;
    private final DatabasePageCache databasePageCache;

    public DefaultForceOperation(IndexingService indexingService, StorageEngine storageEngine, DatabasePageCache databasePageCache) {
        this.indexingService = indexingService;
        this.storageEngine = storageEngine;
        this.databasePageCache = databasePageCache;
    }

    @Override
    public void flushAndForce(DatabaseFlushEvent databaseFlushEvent, CursorContext cursorContext) throws IOException {
        DatabasePageCache.FlushGuard flushGuard = this.databasePageCache.flushGuard(databaseFlushEvent);
        this.indexingService.checkpoint(databaseFlushEvent, cursorContext);
        this.storageEngine.checkpoint(databaseFlushEvent, cursorContext);
        flushGuard.flushUnflushed();
    }
}

