/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.schema;

import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.schema.ConstraintType;
import org.neo4j.graphdb.schema.PropertyType;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.constraints.PropertyTypeSet;
import org.neo4j.internal.schema.constraints.SchemaValueType;
import org.neo4j.kernel.impl.coreapi.schema.InternalSchemaActions;
import org.neo4j.kernel.impl.coreapi.schema.NodeConstraintDefinition;

public class NodePropertyTypeConstraintDefinition
extends NodeConstraintDefinition {
    public NodePropertyTypeConstraintDefinition(InternalSchemaActions actions, ConstraintDescriptor constraint, Label label, String propertyKey) {
        super(actions, constraint, label, new String[]{propertyKey});
    }

    public ConstraintType getConstraintType() {
        this.assertInUnterminatedTransaction();
        return ConstraintType.NODE_PROPERTY_TYPE;
    }

    @Override
    public String toString() {
        return String.format("FOR (%s:%s) REQUIRE %s IS :: %s", this.label.name().toLowerCase(), this.label.name(), this.propertyText(this.label.name().toLowerCase()), this.constraint.asPropertyTypeConstraint().propertyType().userDescription());
    }

    @Override
    public PropertyType[] getPropertyType() {
        this.assertInUnterminatedTransaction();
        PropertyTypeSet propertyTypeSet = this.constraint.asPropertyTypeConstraint().propertyType();
        return (PropertyType[])propertyTypeSet.stream().map(SchemaValueType::toPublicApi).toArray(PropertyType[]::new);
    }
}

