/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.nio.file.Path;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.BlockEntry;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.IndexUpdateCursor;
import org.neo4j.kernel.impl.index.schema.IndexUpdateEntry;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexUpdater;
import org.neo4j.kernel.impl.index.schema.NullValue;
import org.neo4j.kernel.impl.index.schema.SimpleEntryStorage;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.UpdateMode;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.values.storable.Value;

public class IndexUpdateStorage<KEY extends NativeIndexKey<KEY>>
extends SimpleEntryStorage<IndexEntryUpdate<?>, IndexUpdateCursor<KEY, NullValue>> {
    private final IndexLayout<KEY> layout;
    private final KEY key1;
    private final KEY key2;
    private final NullValue value = NullValue.INSTANCE;

    IndexUpdateStorage(FileSystemAbstraction fs, Path file, ByteBufferFactory.Allocator byteBufferFactory, int blockSize, IndexLayout<KEY> layout, MemoryTracker memoryTracker) {
        super(fs, file, byteBufferFactory, blockSize, memoryTracker);
        this.layout = layout;
        this.key1 = (NativeIndexKey)((Object)layout.newKey());
        this.key2 = (NativeIndexKey)((Object)layout.newKey());
    }

    @Override
    public IndexUpdateCursor<KEY, NullValue> reader(PageCursor pageCursor) {
        return new IndexUpdateCursor(pageCursor, this.layout);
    }

    @Override
    public void add(IndexEntryUpdate<?> update, PageCursor pageCursor) throws IOException {
        ValueIndexEntryUpdate valueUpdate = (ValueIndexEntryUpdate)update;
        int entrySize = this.calculateEntrySize(valueUpdate);
        this.write(pageCursor, valueUpdate.updateMode(), entrySize);
    }

    private int calculateEntrySize(ValueIndexEntryUpdate<?> update) {
        long entityId = update.getEntityId();
        Value[] values = update.values();
        UpdateMode updateMode = update.updateMode();
        switch (updateMode) {
            case ADDED: {
                return 1 + this.added(this.key1, entityId, values);
            }
            case CHANGED: {
                return 1 + this.removed(this.key1, entityId, update.beforeValues()) + this.added(this.key2, entityId, values);
            }
            case REMOVED: {
                return 1 + this.removed(this.key1, entityId, values);
            }
        }
        throw new IllegalArgumentException("Unknown update mode " + updateMode);
    }

    private int added(KEY key, long entityId, Value[] values) {
        NativeIndexUpdater.initializeKeyFromUpdate(key, entityId, values);
        return BlockEntry.entrySize(this.layout, key, this.value);
    }

    private int removed(KEY key, long entityId, Value[] values) {
        NativeIndexUpdater.initializeKeyFromUpdate(key, entityId, values);
        return BlockEntry.keySize(this.layout, key);
    }

    private void write(PageCursor pageCursor, UpdateMode updateMode, int entrySize) throws IOException {
        this.prepareWrite(entrySize);
        pageCursor.putByte((byte)updateMode.ordinal());
        IndexUpdateEntry.write(pageCursor, this.layout, updateMode, this.key1, this.key2, this.value);
    }
}

