/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.storageengine.api.TokenIndexEntryUpdate;
import org.neo4j.util.Preconditions;

class PhysicalToLogicalTokenChanges {
    private PhysicalToLogicalTokenChanges() {
    }

    static LogicalTokenUpdates convertToAdditionsAndRemovals(TokenIndexEntryUpdate<?> update) {
        int beforeLength = update.beforeValues().length;
        int afterLength = update.values().length;
        if (update.isLogical()) {
            return new LogicalTokenUpdates(update.getEntityId(), update.beforeValues(), update.values());
        }
        int rc = 0;
        int ac = 0;
        long[] removals = (long[])update.beforeValues().clone();
        long[] additions = (long[])update.values().clone();
        int bi = 0;
        int ai = 0;
        while (bi < beforeLength || ai < afterLength) {
            long afterId;
            long beforeId = bi < beforeLength ? Preconditions.requireNonNegative((long)removals[bi]) : -1L;
            long l = afterId = ai < afterLength ? Preconditions.requireNonNegative((long)additions[ai]) : -1L;
            if (beforeId == afterId) {
                ++bi;
                ++ai;
                continue;
            }
            if (PhysicalToLogicalTokenChanges.smaller(beforeId, afterId)) {
                while (PhysicalToLogicalTokenChanges.smaller(beforeId, afterId) && bi < beforeLength) {
                    removals[rc++] = beforeId;
                    beforeId = ++bi < beforeLength ? removals[bi] : -1L;
                }
                continue;
            }
            if (!PhysicalToLogicalTokenChanges.smaller(afterId, beforeId)) continue;
            while (PhysicalToLogicalTokenChanges.smaller(afterId, beforeId) && ai < afterLength) {
                additions[ac++] = afterId;
                afterId = ++ai < afterLength ? additions[ai] : -1L;
            }
        }
        PhysicalToLogicalTokenChanges.terminateWithMinusOneIfNeeded(removals, rc);
        PhysicalToLogicalTokenChanges.terminateWithMinusOneIfNeeded(additions, ac);
        return new LogicalTokenUpdates(update.getEntityId(), removals, additions);
    }

    private static boolean smaller(long id, long otherId) {
        return id != -1L && (otherId == -1L || id < otherId);
    }

    private static void terminateWithMinusOneIfNeeded(long[] tokenIds, int actualLength) {
        if (actualLength < tokenIds.length) {
            tokenIds[actualLength] = -1L;
        }
    }

    record LogicalTokenUpdates(long entityId, long[] removals, long[] additions) implements Comparable<LogicalTokenUpdates>
    {
        @Override
        public int compareTo(LogicalTokenUpdates o) {
            return Long.compare(this.entityId, o.entityId);
        }
    }
}

