/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.function.LongSupplier;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.transaction.log.LogHeaderCache;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogFormat;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderWriter;
import org.neo4j.kernel.impl.transaction.log.files.ChannelNativeAccessor;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesContext;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesHelper;
import org.neo4j.kernel.impl.transaction.tracing.DatabaseTracer;
import org.neo4j.kernel.impl.transaction.tracing.LogFileCreateEvent;

public class TransactionLogChannelAllocator {
    private final TransactionLogFilesContext logFilesContext;
    private final FileSystemAbstraction fileSystem;
    private final TransactionLogFilesHelper fileHelper;
    private final LogHeaderCache logHeaderCache;
    private final ChannelNativeAccessor nativeChannelAccessor;
    private final DatabaseTracer databaseTracer;

    public TransactionLogChannelAllocator(TransactionLogFilesContext logFilesContext, TransactionLogFilesHelper fileHelper, LogHeaderCache logHeaderCache, ChannelNativeAccessor nativeChannelAccessor) {
        this.logFilesContext = logFilesContext;
        this.fileSystem = logFilesContext.getFileSystem();
        this.databaseTracer = logFilesContext.getDatabaseTracers().getDatabaseTracer();
        this.fileHelper = fileHelper;
        this.logHeaderCache = logHeaderCache;
        this.nativeChannelAccessor = nativeChannelAccessor;
    }

    public PhysicalLogVersionedStoreChannel createLogChannel(long version, LongSupplier lastCommittedTransactionId) throws IOException {
        Path logFile;
        AllocatedFile allocatedFile = this.allocateFile(version);
        StoreChannel storeChannel = allocatedFile.storeChannel();
        LogHeader header = LogHeaderReader.readLogHeader((ReadableByteChannel)storeChannel, false, logFile = allocatedFile.path(), this.logFilesContext.getMemoryTracker());
        if (header == null) {
            try (LogFileCreateEvent ignored = this.databaseTracer.createLogFile();){
                storeChannel.position(0L);
                long lastTxId = lastCommittedTransactionId.getAsLong();
                LogHeader logHeader = new LogHeader(LogFormat.CURRENT_LOG_FORMAT_VERSION, new LogPosition(version, (long)LogFormat.CURRENT_FORMAT_LOG_HEADER_SIZE), lastTxId, this.logFilesContext.getStoreId(), -1, -559063315);
                LogHeaderWriter.writeLogHeader(storeChannel, logHeader, this.logFilesContext.getMemoryTracker());
                this.logHeaderCache.putHeader(version, logHeader);
            }
        }
        byte formatVersion = header == null ? LogFormat.CURRENT_LOG_FORMAT_VERSION : header.getLogFormatVersion();
        return new PhysicalLogVersionedStoreChannel(storeChannel, version, formatVersion, logFile, this.nativeChannelAccessor, this.databaseTracer);
    }

    public PhysicalLogVersionedStoreChannel openLogChannel(long version) throws IOException {
        return this.openLogChannel(version, false);
    }

    public PhysicalLogVersionedStoreChannel openLogChannel(long version, boolean raw) throws IOException {
        Path fileToOpen = this.fileHelper.getLogFileForVersion(version);
        if (!this.fileSystem.fileExists(fileToOpen)) {
            throw new NoSuchFileException(fileToOpen.toAbsolutePath().toString());
        }
        this.databaseTracer.openLogFile(fileToOpen);
        StoreChannel rawChannel = null;
        try {
            rawChannel = this.fileSystem.read(fileToOpen);
            LogHeader header = LogHeaderReader.readLogHeader((ReadableByteChannel)rawChannel, true, fileToOpen, this.logFilesContext.getMemoryTracker());
            if (header == null || header.getLogVersion() != version) {
                throw new IllegalStateException(String.format("Unexpected log file header. Expected header version: %d, actual header: %s", version, header != null ? header.toString() : "null header."));
            }
            PhysicalLogVersionedStoreChannel versionedStoreChannel = new PhysicalLogVersionedStoreChannel(rawChannel, version, header.getLogFormatVersion(), fileToOpen, this.nativeChannelAccessor, this.databaseTracer, raw);
            if (!raw) {
                this.nativeChannelAccessor.adviseSequentialAccessAndKeepInCache(rawChannel, version);
            }
            return versionedStoreChannel;
        }
        catch (NoSuchFileException cause) {
            throw (NoSuchFileException)new NoSuchFileException(fileToOpen.toAbsolutePath().toString()).initCause(cause);
        }
        catch (Throwable unexpectedError) {
            if (rawChannel != null) {
                try {
                    rawChannel.close();
                }
                catch (IOException e) {
                    unexpectedError.addSuppressed(e);
                }
            }
            throw unexpectedError;
        }
    }

    private AllocatedFile allocateFile(long version) throws IOException {
        Path file = this.fileHelper.getLogFileForVersion(version);
        boolean fileExist = this.fileSystem.fileExists(file);
        StoreChannel storeChannel = this.fileSystem.write(file);
        if (fileExist) {
            this.nativeChannelAccessor.adviseSequentialAccessAndKeepInCache(storeChannel, version);
        } else if (this.logFilesContext.getTryPreallocateTransactionLogs().get()) {
            this.nativeChannelAccessor.preallocateSpace(storeChannel, version);
        }
        return new AllocatedFile(file, storeChannel);
    }

    private record AllocatedFile(Path path, StoreChannel storeChannel) {
    }
}

