/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.internal.event;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.neo4j.graphdb.event.TransactionEventListener;
import org.neo4j.kernel.internal.event.GlobalTransactionEventListeners;

public class DefaultGlobalTransactionEventListeners
implements GlobalTransactionEventListeners {
    private final ConcurrentHashMap<String, List<TransactionEventListener<?>>> globalTransactionEventListeners = new ConcurrentHashMap();

    @Override
    public void registerTransactionEventListener(String databaseName, TransactionEventListener<?> listener) {
        Objects.requireNonNull(databaseName, "Database name is required.");
        Objects.requireNonNull(listener, "Transaction event listener is required.");
        this.globalTransactionEventListeners.compute(databaseName, (s, transactionEventListeners) -> {
            List listeners;
            List list = listeners = transactionEventListeners != null ? transactionEventListeners : new CopyOnWriteArrayList();
            if (listeners.contains(listener)) {
                return listeners;
            }
            listeners.add(listener);
            return listeners;
        });
    }

    @Override
    public void unregisterTransactionEventListener(String databaseName, TransactionEventListener<?> listener) {
        Objects.requireNonNull(databaseName);
        Objects.requireNonNull(listener);
        this.globalTransactionEventListeners.compute(databaseName, (s, transactionEventListeners) -> {
            if (transactionEventListeners == null || !transactionEventListeners.remove(listener)) {
                throw new IllegalStateException(String.format("Transaction event listener `%s` is not registered as listener for database `%s`.", listener, databaseName));
            }
            if (transactionEventListeners.isEmpty()) {
                return null;
            }
            return transactionEventListeners;
        });
    }

    @Override
    public Collection<TransactionEventListener<?>> getDatabaseTransactionEventListeners(String databaseName) {
        return this.globalTransactionEventListeners.getOrDefault(databaseName, Collections.emptyList());
    }
}

