/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging.event;

import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.event.EventType;
import org.neo4j.logging.event.Parameters;
import org.neo4j.logging.event.UserEventPublisher;
import org.neo4j.logging.internal.PrefixedLog;
import org.neo4j.logging.internal.PrefixedLogProvider;

public class LoggingUserEventPublisher
implements UserEventPublisher {
    private final InternalLogProvider logProvider;

    LoggingUserEventPublisher(InternalLogProvider logProvider) {
        this.logProvider = logProvider;
    }

    @Override
    public void publish(EventType eventType) {
        this.publish(eventType, Parameters.EMPTY);
    }

    @Override
    public void publish(EventType eventType, Parameters parameters) {
        PrefixedLogProvider prefixLogProvider = new PrefixedLogProvider(this.logProvider, "Event");
        PrefixedLog userLog = (PrefixedLog)prefixLogProvider.getLog(eventType.getComponentNamespace().getName());
        String message = eventType.getMessage();
        String separator = parameters.isEmpty() ? "" : " - ";
        switch (eventType.getLoggingLevel()) {
            case Begin: 
            case Finish: {
                userLog.info("%s - %s%s%s", new Object[]{eventType.getLoggingLevel(), message, separator, parameters});
                break;
            }
            case Info: {
                userLog.info("%s%s%s", message, separator, parameters);
                break;
            }
            case Warn: {
                userLog.warn("%s%s%s", message, separator, parameters);
                break;
            }
            case Error: {
                userLog.error("%s%s%s", message, separator, parameters);
            }
        }
    }
}

