/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging.log4j;

import java.io.OutputStream;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.Level;
import org.neo4j.logging.log4j.Log4jLog;
import org.neo4j.logging.log4j.LogConfig;
import org.neo4j.logging.log4j.LoggerTarget;
import org.neo4j.logging.log4j.Neo4jLoggerContext;

public class Log4jLogProvider
implements InternalLogProvider {
    private final Neo4jLoggerContext ctx;

    public Log4jLogProvider(Neo4jLoggerContext ctx) {
        this.ctx = ctx;
    }

    public Log4jLogProvider(OutputStream out) {
        this(out, Level.INFO);
    }

    public Log4jLogProvider(OutputStream out, Level level) {
        this(LogConfig.createBuilderToOutputStream(out, level).build());
    }

    public void updateLogLevel(Level newLevel) {
        LogConfig.updateLogLevel(newLevel, this.ctx);
    }

    @Override
    public Log4jLog getLog(Class<?> loggingClass) {
        return new Log4jLog(this.ctx.getLogger(loggingClass));
    }

    @Override
    public Log4jLog getLog(String name) {
        return new Log4jLog(this.ctx.getLogger(name));
    }

    @Override
    public Log4jLog getLog(LoggerTarget target) {
        return new Log4jLog(this.ctx.getLogger(target.getTarget()));
    }

    @Override
    public void close() {
        this.ctx.close();
    }
}

