/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging.log4j;

import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.logging.log4j.status.StatusData;
import org.apache.logging.log4j.status.StatusListener;
import org.apache.logging.log4j.status.StatusLogger;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.Level;
import org.neo4j.logging.LoggerPrintStreamAdaptor;
import org.neo4j.util.VisibleForTesting;

public final class SystemLogger {
    private static final StatusLogger STATUS_LOGGER = StatusLogger.getLogger();
    private static final StatusErrorListener ERROR_LISTENER = new StatusErrorListener();

    private SystemLogger() {
    }

    public static void installErrorListener() {
        ERROR_LISTENER.clear();
        STATUS_LOGGER.registerListener((StatusListener)ERROR_LISTENER);
    }

    public static boolean errorsEncounteredDuringSetup() {
        STATUS_LOGGER.removeListener((StatusListener)ERROR_LISTENER);
        return ERROR_LISTENER.haveErrors();
    }

    @VisibleForTesting
    static void printErrorMessages(PrintStream errorOutput) {
        if (ERROR_LISTENER.haveErrors()) {
            ERROR_LISTENER.getErrors().forEach(errorOutput::println);
        }
    }

    public static void installStdRedirects(InternalLogProvider LogProvider2) {
        System.setOut(new LoggerPrintStreamAdaptor(LogProvider2.getLog("stdout"), Level.INFO));
        System.setErr(new LoggerPrintStreamAdaptor(LogProvider2.getLog("stderr"), Level.WARN));
    }

    private static class StatusErrorListener
    implements StatusListener {
        private final ConcurrentLinkedQueue<String> errorMessages = new ConcurrentLinkedQueue();

        private StatusErrorListener() {
        }

        public void log(StatusData data) {
            this.errorMessages.add(data.getFormattedStatus());
        }

        public org.apache.logging.log4j.Level getStatusLevel() {
            return org.apache.logging.log4j.Level.ERROR;
        }

        public void close() throws IOException {
        }

        void clear() {
            this.errorMessages.clear();
        }

        boolean haveErrors() {
            return !this.errorMessages.isEmpty();
        }

        List<String> getErrors() {
            return this.errorMessages.stream().toList();
        }
    }
}

