/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema;

import java.util.Collections;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.factory.Maps;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueCategory;

public final class IndexConfig {
    private static final IndexConfig EMPTY = new IndexConfig((ImmutableMap<String, Value>)Maps.immutable.empty());
    private final ImmutableMap<String, Value> map;

    private IndexConfig(ImmutableMap<String, Value> map) {
        this.map = map;
    }

    public static IndexConfig empty() {
        return EMPTY;
    }

    public static IndexConfig with(String key, Value value) {
        return new IndexConfig((ImmutableMap<String, Value>)Maps.immutable.with((Object)key, (Object)value));
    }

    public static IndexConfig with(Map<String, Value> map) {
        for (Value value : map.values()) {
            IndexConfig.validate(value);
        }
        return new IndexConfig((ImmutableMap<String, Value>)Maps.immutable.withAll(map));
    }

    private static void validate(Value value) {
        ValueCategory category = value.valueGroup().category();
        switch (category) {
            case GEOMETRY: 
            case GEOMETRY_ARRAY: 
            case TEMPORAL: 
            case TEMPORAL_ARRAY: 
            case UNKNOWN: 
            case NO_CATEGORY: {
                throw new IllegalArgumentException("Value type not support in index configuration: " + value + ".");
            }
        }
    }

    public IndexConfig withIfAbsent(String key, Value value) {
        IndexConfig.validate(value);
        if (this.map.containsKey((Object)key)) {
            return this;
        }
        return new IndexConfig((ImmutableMap<String, Value>)this.map.newWithKeyValue((Object)key, (Object)value));
    }

    public <T extends Value> T get(String key) {
        return (T)((Value)this.map.get((Object)key));
    }

    public <T extends Value> T getOrDefault(String key, T defaultValue) {
        T value = this.get(key);
        return value != null ? value : defaultValue;
    }

    public <T extends Value> T getOrThrow(String key) {
        return this.getOrThrow(key, () -> new NoSuchElementException("'%s' is not set".formatted(key)));
    }

    public <T extends Value, E extends Throwable> T getOrThrow(String key, Supplier<? extends E> exceptionSupplier) throws E {
        T value = this.get(key);
        if (value == null) {
            throw (Throwable)exceptionSupplier.get();
        }
        return value;
    }

    public RichIterable<Pair<String, Value>> entries() {
        return this.map.keyValuesView();
    }

    public Map<String, Value> asMap() {
        return Collections.unmodifiableMap(this.map.toMap());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IndexConfig)) {
            return false;
        }
        IndexConfig that = (IndexConfig)o;
        return this.map.equals(that.map);
    }

    public int hashCode() {
        return Objects.hash(this.map);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("IndexConfig[");
        for (Pair entry : this.entries()) {
            sb.append((String)entry.getOne()).append(" -> ").append(entry.getTwo()).append(", ");
        }
        if (!this.map.isEmpty()) {
            sb.setLength(sb.length() - 2);
        }
        sb.append(']');
        return sb.toString();
    }
}

