/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.exceptions;

import org.neo4j.exceptions.Neo4jException;
import org.neo4j.kernel.api.exceptions.Status;

public class FailedIndexException
extends Neo4jException {
    public FailedIndexException(String indexName, String failureMessage) {
        super(FailedIndexException.msg(indexName, failureMessage), null);
    }

    private static String msg(String indexName, String failureMessage) {
        String actualFailure = failureMessage != null ? String.format(" Actual failure:%s==================%s%s%s==================", System.lineSeparator(), System.lineSeparator(), failureMessage, System.lineSeparator()) : "";
        return String.format("Index `%s` has failed. Drop and recreate it to get it back online.%s", indexName, actualFailure);
    }

    public Status status() {
        return Status.General.IndexCorruptionDetected;
    }
}

