/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.negotiation;

import java.util.Objects;

public record ProtocolVersion(short major, short minor, short range) implements Comparable<ProtocolVersion>
{
    public static final int ENCODED_SIZE = 4;
    public static final ProtocolVersion INVALID = new ProtocolVersion(0, 0, 0);
    public static final int MAX_MAJOR_BIT = 255;
    public static final int MAX_MINOR_BIT = 255;

    public ProtocolVersion {
        if (major < 0 || major > 255) {
            throw new IllegalArgumentException("Expected major version bit to be in bounds 0 <= x < 255: Got " + major);
        }
        if (minor < 0 || minor > 255) {
            throw new IllegalArgumentException("Expected minor version bit to be in bounds 0 <= x < 255: Got " + minor);
        }
        if (range > minor) {
            throw new IllegalArgumentException("Expected range bit to be in bounds 0 <= x < " + minor + ": Got " + range);
        }
    }

    public ProtocolVersion(int major, int minor, int range) {
        this((short)major, (short)minor, (short)range);
    }

    public ProtocolVersion(short major, short minor) {
        this(major, minor, 0);
    }

    public ProtocolVersion(int major, int minor) {
        this((short)major, (short)minor);
    }

    public ProtocolVersion(int encoded) {
        this((short)(encoded & 0xFF), (short)(encoded >>> 8 & 0xFF), (short)(encoded >>> 16 & 0xFF));
    }

    public short getMajor() {
        return this.major;
    }

    public short getMinor() {
        return this.minor;
    }

    public short getRange() {
        return this.range;
    }

    public boolean matches(ProtocolVersion other) {
        if (this.range == 0) {
            return this.equals(other);
        }
        if (this.major != other.major) {
            return false;
        }
        int lowerBound = this.minor - this.range;
        return other.minor >= lowerBound && other.minor <= this.minor;
    }

    public int encode() {
        return this.major & 0xFF ^ (this.minor & 0xFF) << 8 ^ (this.range & 0xFF) << 16;
    }

    @Override
    public int compareTo(ProtocolVersion o) {
        int result = Short.compare(this.major, o.major);
        return result != 0 ? result : Short.compare(this.minor, o.minor);
    }

    @Override
    public String toString() {
        if (this.range != 0) {
            int lowerBound = this.minor - this.range;
            return String.format("[%1$d.%2$d,%1$d.%3$d]", this.major, lowerBound, this.minor);
        }
        return String.format("%d.%d", this.major, this.minor);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProtocolVersion that = (ProtocolVersion)o;
        return this.major == that.major && this.minor == that.minor && this.range == that.range;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.range);
    }
}

